/*
 * nestedtable_dml1.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie funkcji skadowanych do obsugi
 * relacji "jeden do wielu" w tabeli zagniedonej w wierszu danych
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Porzdkowanie rodowiska
BEGIN

  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 21) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 21';
  END LOOP;

  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 21) LOOP
    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 21';
  END LOOP;

  COMMIT;

END;
/

-- Wstawianie danych do tabeli individuals z powodu ograniczenia zwizanego z kluczem nadrzdnym
INSERT
INTO     individuals
VALUES
('21'
,'Jan'
,''
,'Kowalski');

-- Wstawianie danych do tabeli addresses przy uyciu tabeli zagniedonej
INSERT
INTO     addresses
VALUES
(21
,21
,address_table
  ('Biuro senatora Kowalskiego'
  ,'Zachodnia 1'
  ,'Apartament 200')
,'Warszawa'
,'MAZ'
,'85-701'
,'PL');

-- Zwyka instrukcja SELECT
SELECT   street_address
FROM     addresses;

-- Uywanie SQL*Plus do formatowania danych wyjciowych
COL column_value FORMAT A30

-- Wywietlanie listy elementw tabeli zagniedonej
SELECT   column_value
FROM     THE (SELECT   street_address
              FROM     addresses
              WHERE    address_id = 21);

-- Uywanie SQL*Plus do formatowania danych wyjciowych
COL data FORMAT A30

-- Wywietlanie listy zczonych elementw
SELECT   s.data
FROM    (SELECT   1 ordering
         ,        rownum roworder
         ,        individual_id
         ,        first_name
         ||       ' '
         ||       middle_initial
         ||       ' '
         ||       last_name data
         FROM     individuals i2
         UNION ALL
         SELECT   2 ordering
         ,        rownum roworder
         ,        individual_id
         ,        column_value data
         FROM     THE (SELECT   street_address
                       FROM     addresses)
         ,        addresses
         UNION ALL
         SELECT   3 ordering
         ,        rownum roworder
         ,        individual_id
         ,        city
         ||       ', '
         ||       state
         ||       ' '
         ||       postal_code data
         FROM     addresses a
         ORDER BY 1,2) s
,        individuals i
WHERE    s.individual_id = i.individual_id
AND      i.individual_id = 21;

-- Utworzono...
CREATE OR REPLACE FUNCTION many_to_one
  (street_address_in ADDRESS_TABLE)
RETURN VARCHAR2 IS

  -- Definicja zwracanej zmiennej i inicjowanie jej acuchem znakw o zerowej dugoci
  retval VARCHAR2(4000) := '';

BEGIN

  FOR i IN 1..street_address_in.COUNT LOOP

    retval := retval || street_address_in(i) || CHR(10);

  END LOOP;

  RETURN retval;

END many_to_one;
/ 


SELECT   i.first_name || ' '
||       i.middle_initial || ' '
||       i.last_name || CHR(10)
||       many_to_one(a.street_address)
||       city || ', '
||       state || ' '
||       postal_code address_label
FROM     addresses a
,        individuals i
WHERE    a.individual_id = i.individual_id
AND      i.individual_id = 21;
