/*
 * create_varray2.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt definiuje tablic varray za pomoc konstruktora i elementu null, a nastpnie
 * rozszerza j po jednym elemencie
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicja tablicy VARRAY o trzech wierszach przechowujcej liczby cakowite
  TYPE integer_varray IS VARRAY(3) OF INTEGER;

  -- Deklarowanie i inicjowanie pustego zbioru wierszy
  varray_integer INTEGER_VARRAY := integer_varray();

BEGIN

  -- Przejcie w ptli po trzech rekordach
  FOR i IN 1..3 LOOP

    -- Inicjowanie wiersza
    varray_integer.EXTEND;

    -- Przypisywanie wartoci do indeksowanych elementw tablicy VARRAY 
    varray_integer(i) := 10 + i;

  END LOOP;

  -- Wywietlanie nagwka
  dbms_output.put_line('Tablica VARRAY zainicjowana za pomoc wartosci.');
  dbms_output.put_line('------------------------------------------------');

  -- Przejcie w ptli po rekordach i wywietlenie wartoci
  FOR i IN 1..3 LOOP

    -- Wywietlenie zawartoci
    dbms_output.put     ('varray_integer ['||i||'] ');
    dbms_output.put_line('['||varray_integer(i)||']');

  END LOOP;

END;
/

