/*
 * create_nestedtable3.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt tworzy w bazie danych pust tabel zagniedon, a nastpnie rozszerza j po jednym elemencie
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Definicja tabeli acuchw znakw o zmiennej dugoci
CREATE OR REPLACE TYPE card_table
  AS TABLE OF VARCHAR2(5 CHAR);
/

DECLARE

  -- Deklaracja i inicjowanie tabeli zagniedonej o trzech wierszach
  cards CARD_TABLE := card_table(NULL,NULL,NULL);

BEGIN

  -- Wywietlanie nagwka
  dbms_output.put_line(
    'Tabela zagniezdzona zainicjowana wartosciami NULL.');
  dbms_output.put_line(
    '--------------------------------------------------');

  -- Przejcie w ptli po rekordach
  FOR i IN 1..3 LOOP

    -- Wywietlenie zawartoci
    dbms_output.put     ('cards ['||i||'] ');
    dbms_output.put_line('['||cards(i)||']');

  END LOOP;

  -- Przypisanie wartoci do indeksowanych elementw tabeli
  cards(1) := 'As';
  cards(2) := 'Dwojka';
  cards(3) := 'Trojka';

  -- Wywietlanie nagwka
  dbms_output.put     (CHR(10)); -- Widoczne przeamanie wiersza
  dbms_output.put_line(
    'Tabela zagniezdzona zainicjowana asem, dwojka i trojka.');
  dbms_output.put_line(
    '-----------------------------------------------');

  -- Przejcie w ptli po trzech rekordach w celu wywietlenia tabeli zagniedonej
  FOR i IN 1..3 LOOP

    dbms_output.put_line('Tabela cards ['||i||'] '
    ||                   '['||cards(i)||']');

  END LOOP;

END;
/

