/*
 * create_assocarray6.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje inicjowanie i przypisywanie danych tablicy asocjacyjnej
 * przy uyciu indeksw w postaci niepowtarzalnych acuchw znakw
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

DECLARE

  -- Definicje zmiennych sucych do poruszania si po tablicy asocjacyjnej
  -- o indeksach w postaci acuchw znakw o zmiennej dugoci
  current VARCHAR2(11 CHAR);
  element INTEGER;

  -- Definicja tablicy VARRAY o 12 acuchw znakw o zmiennej dugoci 
  TYPE months_varray IS VARRAY(12) OF STRING(11 CHAR);
   
  -- Definicja tablicy asocjacyjnej acuchw znakw o zmiennej dugoci 
  TYPE calendar_table IS TABLE OF VARCHAR2(11 CHAR)
    INDEX BY VARCHAR2(11 CHAR);

  -- Deklaracja i tworzenie tablicy VARRAY 
  month MONTHS_VARRAY := 
    months_varray('Styczen','Luty','Marzec'
                 ,'Kwiecien','Maj','Czerwiec'
                 ,'Lipiec','Sierpien','Wrzesien'
                 ,'Pazdziernik','Listopad','Grudzien');

  -- Deklaracja zmiennej typu tablicy asocjacyjnej 
  calendar CALENDAR_TABLE;

BEGIN

  -- Sprawdzenie, czy tablica calendar nie ma elementw 
  IF calendar.COUNT = 0 THEN

    -- Wywietlenie nagwka
    DBMS_OUTPUT.PUT_LINE('Petla z przypisaniem:');
    DBMS_OUTPUT.PUT_LINE('---------------------');

    -- Przejcie w ptli po wszystkich elementach tablicy VARRAY 
    FOR i IN month.FIRST..month.LAST LOOP

      -- Przypisanie indeksu elementu tablicy VARRAY 
      -- do elementu tablicy asocjacyjnej o indeksie w postaci nazwie miesica
      calendar(month(i)) := TO_CHAR(i);

      -- Wywietlenie indeksowanych elementw tablicy asocjacyjnej 
      DBMS_OUTPUT.PUT_LINE(
        'Element ['||month(i)||'] ma wartosc ['||i||']');

    END LOOP;

    -- Wywietlenie nagwka
    DBMS_OUTPUT.PUT(CHR(10));
    DBMS_OUTPUT.PUT_LINE('Petla po przypisaniu:');
    DBMS_OUTPUT.PUT_LINE('---------------------');

    -- Przejcie w ptli po wszystkich elementach tablicy asocjacyjnej 
    FOR i IN 1..calendar.COUNT LOOP

      -- Sprawdzenie, czy jest to pierwszy element w ptli 
      IF i = 1 THEN

        -- Przypisanie pierwszego indeksu znakowego do zmiennej 
        current := calendar.FIRST;

        -- Uycie otrzymanego indeksu do znalezienia nastpnego 
        element := calendar(current);

      ELSE

        -- Sprawdzenie, czy nastpny indeks istnieje 
        IF calendar.NEXT(current) IS NOT NULL THEN

          -- Przypisanie indeksu znakowego do zmiennej 
          current := calendar.NEXT(current);

          -- Uycie otrzymanego indeksu do znalezienia nastpnego
          element := calendar(current);

        ELSE

          -- Wyjcie z ptli, poniewa ostatni indeks zosta ju wczytany 
          EXIT;

        END IF;
        
      END IF;

      -- Wywietlenie indeksowanych elementw tablicy asocjacyjnej 
      DBMS_OUTPUT.PUT_LINE(
        'Element ['||current||'] ma wartosc ['||element||']');

    END LOOP;

  END IF;

END;
/

