/*
 * bulk_collect2.sql
 * Rozdzia 6, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje, jak stosowa masowe pobieranie
 * danych do tabeli zagniedonej
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

BEGIN
  FOR i IN (SELECT null
            FROM user_tables
            WHERE table_name = 'BULK_NUMBERS') LOOP
    EXECUTE IMMEDIATE 'DROP TABLE bulk_numbers CASCADE CONSTRAINTS';
  END LOOP;
END;
/

-- Tworzenie tabeli na potrzeby przykadu
CREATE TABLE bulk_numbers
(number_id                NUMBER              NOT NULL
,CONSTRAINT number_id_pk  PRIMARY KEY (number_id));

-- Uycie instrukcji FORALL w celu przeniesienia tabeli zagniedonejdo tabeli
DECLARE

  -- Definicja tabeli zagniedonej liczb cakowitych
  TYPE number_table IS TABLE OF bulk_numbers.number_id%TYPE;

  -- Definicja zmiennej typu tabeli zagniedonej
  number_list NUMBER_TABLE := number_table();

BEGIN

  -- Rozszerzenie tabeli number_list
  number_list.EXTEND(10000);

  -- Przejcie w ptli od 1 do 10000  i zwikszanie tablicy asocjacyjnej
  FOR i IN 1..10000 LOOP

    -- Przypisanie liczby
    number_list(i) := i;

  END LOOP;

  -- Przejcie w ptli po wszystkich elementach w celu masowego wstawienia danych
  FORALL i IN 1..number_list.COUNT
    INSERT
    INTO     bulk_numbers
    VALUES  (number_list(i));

  -- Zatwierdzenie rekordw
  COMMIT;

END;
/

-- Zastosowanie instrukcji BULK COLLECT w celu pobrania tabeli do
-- tabeli zagniedonej
DECLARE

  -- Definicja tabeli zagniedonej liczb cakowitych
  TYPE number_table IS TABLE OF bulk_numbers.number_id%TYPE;

  -- Definicja zmiennej typu tabeli zagniedonej
  number_list NUMBER_TABLE := number_table();

BEGIN

  -- Pobranie wszystkich wierszy za pomoc BULK COLLECT
  SELECT   number_id
  BULK COLLECT
  INTO     number_list
  FROM     bulk_numbers
  ORDER BY 1;

  -- Wywietlenie nagwka
  DBMS_OUTPUT.PUT_LINE('Pobieranie masowe:');
  DBMS_OUTPUT.PUT_LINE('---------------');

  -- Przejcie w ptli w celu wywietlenia elementw
  FOR i IN number_list.FIRST..number_list.LAST LOOP

    -- Wywietlenie tylko dwch pierwszych i ostatnich elementw
    IF i <= 2 OR i >= 9999 THEN

      -- Wywietlenie indeksowanego elementu z tabeli
      DBMS_OUTPUT.PUT_LINE('Numer ['||number_list(i)||']');

    END IF;

  END LOOP;

END;
/