/*
 * create_record7.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje przekazywanie obiektw bazy danych jako argumentw do procedur
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Ten blok anonimowy gwarantuje, e klucz gwny nie zostanie naruszony, a take
-- usuwa istniejc struktur rekordu ze uywanego schematu bazy danych
BEGIN
  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     addresses
            WHERE    address_id = 4) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM addresses WHERE address_id = 4';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 7) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 7';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INDIVIDUAL_ADDRESS_RECORD') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE individual_address_record';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INDIVIDUAL_RECORD') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE individual_record';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'ADDRESS_RECORD') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE address_record';
    COMMIT;

  END LOOP;

END;
/

-- Tworzenie typu obiektowego dla bazy danych
CREATE OR REPLACE TYPE individual_record AS OBJECT
  (individual_id  INTEGER
  ,first_name     VARCHAR2(30 CHAR)
  ,middle_initial VARCHAR2(1 CHAR)
  ,last_name      VARCHAR2(30 CHAR)
  ,CONSTRUCTOR FUNCTION individual_record
  (individual_id  INTEGER
  ,first_name     VARCHAR2
  ,middle_initial VARCHAR2
  ,last_name      VARCHAR2)
  RETURN SELF AS RESULT)
  INSTANTIABLE NOT FINAL;
/

show errors

-- Tworzenie ciaa obiektu z bazy danych
CREATE OR REPLACE TYPE BODY individual_record AS
  CONSTRUCTOR FUNCTION individual_record
  (individual_id  INTEGER
  ,first_name     VARCHAR2
  ,middle_initial VARCHAR2
  ,last_name      VARCHAR2)
  RETURN SELF AS RESULT IS
  BEGIN
    self.individual_id := individual_id;
    self.first_name := first_name;
    self.middle_initial := middle_initial;
    self.last_name := last_name;
    RETURN;
  END;
END;
/

show errors

-- Tworzenie typu obiektowego dla bazy danych
CREATE OR REPLACE TYPE address_record AS OBJECT
  (address_id      INTEGER
  ,individual_id   INTEGER
  ,street_address1 VARCHAR2(30 CHAR)
  ,street_address2 VARCHAR2(30 CHAR)
  ,street_address3 VARCHAR2(30 CHAR)
  ,city            VARCHAR2(20 CHAR)
  ,state           VARCHAR2(20 CHAR)
  ,postal_code     VARCHAR2(20 CHAR)
  ,country_code    VARCHAR2(10 CHAR)
  ,CONSTRUCTOR FUNCTION address_record
  (address_id      INTEGER
  ,individual_id   INTEGER
  ,street_address1 VARCHAR2
  ,street_address2 VARCHAR2
  ,street_address3 VARCHAR2
  ,city            VARCHAR2
  ,state           VARCHAR2
  ,postal_code     VARCHAR2
  ,country_code    VARCHAR2)
  RETURN SELF AS RESULT)
  INSTANTIABLE NOT FINAL;
/

show errors

-- Tworzenie ciaa obiektu z bazy danych
CREATE OR REPLACE TYPE BODY address_record AS
  CONSTRUCTOR FUNCTION address_record
  (address_id      INTEGER
  ,individual_id   INTEGER
  ,street_address1 VARCHAR2
  ,street_address2 VARCHAR2
  ,street_address3 VARCHAR2
  ,city            VARCHAR2
  ,state           VARCHAR2
  ,postal_code     VARCHAR2
  ,country_code    VARCHAR2)
  RETURN SELF AS RESULT IS
  BEGIN
    -- Tworzenie atrybutw obiektu
    self.address_id := address_id;
    self.individual_id := individual_id;
    self.street_address1 := street_address1;
    self.street_address2 := street_address2;
    self.street_address3 := street_address3;
    self.city := city;
    self.state := state;
    self.postal_code := postal_code;
    self.country_code := country_code;
    RETURN;
  END;
END;
/

show errors

-- Tworzenie typu obiektowego dla bazy danych
CREATE OR REPLACE TYPE individual_address_record AS OBJECT
  (individual      INDIVIDUAL_RECORD
  ,address         ADDRESS_RECORD
  ,CONSTRUCTOR FUNCTION individual_address_record
  (individual      INDIVIDUAL_RECORD
  ,address         ADDRESS_RECORD)
  RETURN SELF AS RESULT)
  INSTANTIABLE NOT FINAL;
/

show errors

-- Tworzenie ciaa obiektu z bazy danych
CREATE OR REPLACE TYPE BODY individual_address_record AS
  CONSTRUCTOR FUNCTION individual_address_record
  (individual      INDIVIDUAL_RECORD
  ,address         ADDRESS_RECORD)
  RETURN SELF AS RESULT IS
  BEGIN
    -- Przypisanie egzemplarza typu INDIVIDUAL_RECORD
    self.individual := individual;

    -- Przypisanie egzemplarza typu ADDRESS_RECORD
    self.address := address;
    RETURN;
  END;
END;
/

show errors

-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definicja zmiennej typu rekordowego
  individual_address INDIVIDUAL_ADDRESS_RECORD;

  -- Definicja procedury lokalnej sucej do zarzdzania wstawianiem adresw
  PROCEDURE insert_address
    (address_in ADDRESS_RECORD) IS

  BEGIN

    -- Wstawianie wartoci do obiektu docelowego
    INSERT
    INTO     addresses
    VALUES
    (address_in.address_id
    ,address_in.individual_id
    ,address_in.street_address1
    ,address_in.street_address2
    ,address_in.street_address3
    ,address_in.city
    ,address_in.state
    ,address_in.postal_code
    ,address_in.country_code);

  END insert_address; 

  -- Definicja procedury lokalnej sucej do wstawiania danych osb
  PROCEDURE insert_individual
    (individual_in INDIVIDUAL_RECORD) IS

  BEGIN

    -- Wstawianie wartoci do tabeli
    INSERT
    INTO     individuals
    VALUES
    (individual_in.individual_id
    ,individual_in.first_name
    ,individual_in.middle_initial
    ,individual_in.last_name);

  END insert_individual; 

BEGIN

  -- Tworzenie egzemplarza typu obiektowego.
  -- W konstruktorze uywane s dwa konstruktory zagniedone
  individual_address :=
    individual_address_record(
      individual_record(7,'Jan','','Kowalski'),
      address_record(4,7,'Polna 1','',''
                    ,'Warszawa','MAZ','00-100','PL'));

  -- Tworzenie punktu zapisu
  SAVEPOINT addressbook;

  -- Przetwarzanie podtypw obiektowych
  insert_individual(individual_address.individual); 
  insert_address(individual_address.address); 

  -- Zatwierdzanie rekordu
  COMMIT;

EXCEPTION

  -- Wycofuje zmiany do punktu zapisu w przypadku bdu
  WHEN OTHERS THEN
    ROLLBACK to addressbook;
    RETURN;

END;
/    
