/*
 * create_record4.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie obiektu bazy danych do definiowania typu rekordowego
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Ten blok anonimowy gwarantuje, e klucz gwny nie zostanie naruszony, a take
-- usuwa istniejc struktur rekordu ze uywanego schematu bazy danych
BEGIN
  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 4) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 4';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INDIVIDUAL_ADDRESS_RECORD') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE individual_address_record';
    COMMIT;

  END LOOP;

  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     user_types
            WHERE    type_name = 'INDIVIDUAL_RECORD') LOOP

    EXECUTE IMMEDIATE 'DROP TYPE individual_record';
    COMMIT;

  END LOOP;

END;
/

-- Tworzenie typu obiektowego dla bazy danych
CREATE OR REPLACE TYPE individual_record AS OBJECT
  (individual_id  INTEGER
  ,first_name     VARCHAR2(30 CHAR)
  ,middle_initial VARCHAR2(1 CHAR)
  ,last_name      VARCHAR2(30 CHAR)
  ,CONSTRUCTOR FUNCTION individual_record
  (individual_id  INTEGER
  ,first_name     VARCHAR2
  ,middle_initial VARCHAR2
  ,last_name      VARCHAR2)
  RETURN SELF AS RESULT)
  INSTANTIABLE NOT FINAL;
/

show errors

-- Tworzenie ciaa typu obiektowego bazy danych
CREATE OR REPLACE TYPE BODY individual_record AS
  CONSTRUCTOR FUNCTION individual_record
  (individual_id  INTEGER
  ,first_name     VARCHAR2
  ,middle_initial VARCHAR2
  ,last_name      VARCHAR2)
  RETURN SELF AS RESULT IS
  BEGIN
    self.individual_id := individual_id;
    self.first_name := first_name;
    self.middle_initial := middle_initial;
    self.last_name := last_name;
    RETURN;
  END;
END;
/

show errors

-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definiowanie zmiennej typu rekordowego
  individual INDIVIDUAL_RECORD;

BEGIN

  -- Tworzenie egzemplarza typu obiektowego i przypisywanie do niego wartoci

  individual := individual_record(4,'Mieszko','II','Lambert');

  -- Wstawianie wartoci do tabeli
  INSERT
  INTO     individuals
  VALUES
  (individual.individual_id
  ,individual.first_name
  ,individual.middle_initial
  ,individual.last_name);

  -- Zatwierdzenie operacji
  COMMIT;

END;
/    
