/*
 * create_record2.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie jawnych definicji do definiowania typu rekordowego
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Ten blok anonimowy gwarantuje, e klucz gwny nie zostanie naruszony
BEGIN
  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 2) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 2';
    COMMIT;

  END LOOP;

END;
/

-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definiowanie typu rekordowego
  TYPE individual_record IS RECORD
  (individual_id   INTEGER
  ,first_name      VARCHAR2(30 CHAR)
  ,middle_initial  individuals.middle_initial%TYPE
  ,last_name       VARCHAR2(30 CHAR));

  -- Definiowanie zmiennej typu rekordowego
  individual INDIVIDUAL_RECORD;

BEGIN

  -- Inicjowanie wartoci pl rekordu
  individual.individual_id := 2;
  individual.first_name := 'Bolko';
  individual.middle_initial := 'I';
  individual.last_name := 'Opolski';

  -- Wstawianie wartoci do tabeli
  INSERT
  INTO     individuals
  VALUES
  (individual.individual_id
  ,individual.first_name
  ,individual.middle_initial
  ,individual.last_name);

  -- Zatwierdzenie operacji
  COMMIT;

END;
/ 
