/*
 * create_record1.sql
 * Rozdzia 5, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje uywanie typu rekordowego do zapeniania tabeli
 */

SET ECHO ON
SET SERVEROUTPUT ON SIZE 1000000

-- Ten blok anonimowy gwarantuje, e klucz gwny nie zostanie naruszony
BEGIN
  -- Jeli skrypt znajdzie rekord, usunie go w ptli
  FOR i IN (SELECT   null
            FROM     individuals
            WHERE    individual_id = 1) LOOP

    EXECUTE IMMEDIATE 'DELETE FROM individuals WHERE individual_id = 1';
    COMMIT;

  END LOOP;

END;
/

-- Blok anonimowy zapisujcy rekord do wiersza
DECLARE

  -- Definicja zmiennej utworzonego niejawnie typu rekordowego
  individual individuals%ROWTYPE;

BEGIN

  -- Inicjowanie wartoci pl rekordu
  individual.individual_id := 1;
  individual.first_name := 'Jan';
  individual.middle_initial := 'Ks.';
  individual.last_name := 'Raciborski';

  -- Wstawianie wartoci do tabeli
  INSERT
  INTO     individuals
  VALUES
  (individual.individual_id
  ,individual.first_name
  ,individual.middle_initial
  ,individual.last_name);

  -- Zatwierdzenie operacji
  COMMIT;

END;
/    
