/*
 * Conversion.sql
 * Rozdzia 4, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje dziaanie funkcji do konwersji danych
 */

SET SERVEROUTPUT ON
DECLARE
   v_sysdate DATE := SYSDATE;
   v_date DATE;
   v_char VARCHAR2(20);
BEGIN

   -- Wywietlanie biecej daty
   DBMS_OUTPUT.PUT_LINE('Dzisiejsza data: '||v_sysdate);

   -- Wywietlanie biecej daty i czasu jako sformatowanego acucha znakw
   v_char := TO_CHAR(v_sysdate, 'DD:MM:YYYY HH24:MI:SS');
   DBMS_OUTPUT.PUT_LINE('Wyswietlona jako lancuch znakow DD:MM:YYYY HH24:MI:SS: '
                         ||v_char);

   -- Przeksztacenie acucha znakw z powrotem na format daty
   v_date := TO_DATE(v_char, 'DD:MM:YYYY HH24:MI:SS');
   DBMS_OUTPUT.PUT_LINE('Przeksztalcona z powrotem na format daty: '||v_date);


END;
/

