/*
 * StringLiteral.sql
 * Rozdzia 3, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje rne sposoby obsugi
 *  apostrofw w Oracle 10g.
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables

SET SERVEROUTPUT ON

PROMPT
PROMPT ** Ponizszy blok zglosi wyjatek
PROMPT

BEGIN
   DBMS_OUTPUT.PUT_LINE('Ogrod Mike'a jest CUDOWNY');
END;
/

PROMPT
PROMPT ** Uzycie dwoch apostrofow powoduje poprawne wyswietlenie lancucha
PROMPT

BEGIN
   DBMS_OUTPUT.PUT_LINE('Ogrod Mike''a jest CUDOWNY');
END;
/

PROMPT
PROMPT ** Nowa skladnia cytowania to q'[ ... ]', gdzie [] to ogranicznik zdefiniowany
PROMPT **  przez uzytkownika.  Zamiast [] mozna uzyc dowolnego znaku, ktorego nie
PROMPT **  obejmuje dany literal.
PROMPT


BEGIN
   DBMS_OUTPUT.PUT_LINE('Ogrod Mike''a jest CUDOWNY');
   DBMS_OUTPUT.PUT_LINE(q'!Ogrod Mike'a jest CUDOWNY!');
   DBMS_OUTPUT.PUT_LINE(q'[Ogrod Mike'a jest CUDOWNY]');
   DBMS_OUTPUT.PUT_LINE(q'<Ogrod Mike'a jest CUDOWNY>');
   DBMS_OUTPUT.PUT_LINE(q'%Ogrod Mike'a jest CUDOWNY%');
END;
/
