/*
 * Number.sql
 * Rozdzia 3, Oracle10g. Programowanie w jzyku PL/SQL
 * Ron Hardman, Mike McLaughlin i Scott Urman
 *
 * Ten skrypt demonstruje typ danych NUMBER
 */

exec clean_schema.trigs
exec clean_schema.procs
exec clean_schema.tables

CREATE TABLE precision (
   value NUMBER(38,5),
   scale NUMBER(10));

INSERT INTO precision (value, scale)
   VALUES (12345, 0);
INSERT INTO precision (value, scale)
   VALUES (123456, 0);
INSERT INTO precision (value, scale)
   VALUES (123.45, 0);
INSERT INTO precision (value, scale)
   VALUES (12345, 2);
INSERT INTO precision (value, scale)
   VALUES (123.45, 2);
INSERT INTO precision (value, scale)
   VALUES (12.345, 2);
INSERT INTO precision (value, scale)
   VALUES (1234.5, 2);

commit;

SET SERVEROUTPUT ON

DECLARE
   v_integer NUMBER(5);
   v_scale_2 NUMBER(5,2);
   v_real NUMBER;

   CURSOR scale_0_cur
   IS
      SELECT value
      FROM precision
      WHERE scale = 0;

   CURSOR scale_2_cur
   IS
      SELECT value
      FROM precision
      WHERE scale = 2;
BEGIN

   DBMS_OUTPUT.PUT_LINE('====== PRECYZJA 5 SKALA 0 =====');

   OPEN scale_0_cur;

   -- Przechodzi w ptli po wszystkich rekordach o skali zero
   LOOP
   FETCH scale_0_cur INTO v_real;
   EXIT WHEN scale_0_cur%NOTFOUND;

   -- Przypisanie rnych wartoci do zmiennej v_integer
   -- w celu sprawdzenia, jak je obsuy
   BEGIN
      DBMS_OUTPUT.PUT_LINE('=====================');
      DBMS_OUTPUT.PUT_LINE('Przypisano: '||v_real);

      v_integer := v_real;

      DBMS_OUTPUT.PUT_LINE('Zapisano: '||v_integer);
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.PUT_LINE('Wyjatek: '||sqlerrm);
   END;
   END LOOP;

   CLOSE scale_0_cur;

   DBMS_OUTPUT.PUT_LINE('================================');
   DBMS_OUTPUT.PUT_LINE('====== PRECYZJA 5 SKALA 2 =====');

   OPEN scale_2_cur;

   -- Przejcie w ptli po wszystkich rekordach o skali 2
   LOOP
   FETCH scale_2_cur INTO v_real;
   EXIT WHEN scale_2_cur%NOTFOUND;

   -- Przypisanie rnych wartoci do zmiennej v_scale_2
   -- w celu sprawdzenia, jak je obsuy
   BEGIN
      DBMS_OUTPUT.PUT_LINE('====================');
      DBMS_OUTPUT.PUT_LINE('Przypisano: '||v_real);
      
      v_scale_2 := v_real;
      DBMS_OUTPUT.PUT_LINE('Zapisano: '||v_scale_2);
   EXCEPTION
      WHEN OTHERS
      THEN
         DBMS_OUTPUT.PUT_LINE('Wyjatek: '||sqlerrm);
   END;
   END LOOP;

   CLOSE scale_2_cur;

END;
/

