 // Misja w nadprzestrzeń C++14/17, program z paragrafu    3.12.3

#include <iostream>
#include <string>
#include <tuple> 													// `1
using namespace std;
/////////////////////////////////////////////////////////////////////////////////////////
class Tduet_nasz													// `2
{
private:
	string nazwa;													// `3
	char niewazny;
	double liczba;													// `4
public:
	Tduet_nasz(string nazwa_, double liczba_) : 				// konstruktor
								nazwa(nazwa_), niewazny('x'), liczba(liczba_)
	{ }
	//--------------------------------------
	string daj_nazwe() {
		return nazwa;
	}
	double daj_liczbe() {
		return liczba;
	}
	//--------------------------------------
	// Gdy mamy dostęp do definicji „naszej” klasy, to pomocnicze
	// funkcje get możemy zrealizować za pomocą szablonu funkcji składowych.
	// To pozwoli im korzystać z prywatnych składników klasy.
	template<std::size_t Nr>										// `5
	decltype(auto) get()
	{
		if constexpr (Nr == 0)
			return (nazwa); 		// <--- nawias robi z tego referencję 	// `6
		else if constexpr (Nr == 1)
			return (liczba); 		// <--- nawias robi z tego referencję 	// `7
		// else if constexpr...  tu ewentualne następne dowiązania
	}
};
/////////////////////////////////////////////////////////////////////////////////////////
// Specjalizacja klasy, która powie kompilatorowi, ile będzie dowiązań do klasy Tduet_nasz
template< >
struct std::tuple_size<Tduet_nasz>									// `8
{
	static const size_t value = 2;
};
/////////////////////////////////////////////////////////////////////////////////////////
// Specjalizacje klas, które określą typ dowiązywanych składników w klasie
#define RECZNIE true												 // `9
#if RECZNIE == true
// Gdy decydujemy, że sami zrobimy specjalizacje klasy dla każdego z dowiązań
// ----------------------------------- Specjalizacja dla dowiązania 0 ---
template< >
struct std::tuple_element<0, Tduet_nasz> 								// `10
{
	using type = string;
};
// ------------------------------------ Specjalizacja dla dowiązania 1 ---
template< >
struct std::tuple_element<1, Tduet_nasz>							 	// `11
{
	using type = double;
};
#else  // Możemy to zrobić automatycznie (z użyciem operatora decltype)
template<size_t Nr>		// (tzw. specjalizacja częściowa)
struct tuple_element <Nr, Tduet_nasz>								// `12
{
	using type = decltype(declval<Tduet_nasz>().get<Nr>() );
};
#endif
//*******************************************************************
int main()
{
	Tduet_nasz obj {"Apollo", 99.5}; 									// `13
	// ------------- dowiązanie do kopii -----
	auto [naz, licz] { obj} ;											// `14
	naz = "ZEUS";													// `15
	licz += 400;													// `16

	cout << "naz = " << naz << ", licz = " << licz 						// `17
		<< ", a oryginalny obj (" << obj.daj_nazwe()
		<< ", " <<  obj.daj_liczbe() << ")"<< endl;						// `18

	// ------------dowiązania do referencji -----
	auto & [rnaz, rlicz] { obj} ;										// `19
	rnaz = "ZEUS";
	rlicz += 400;
	cout << "rnaz = " << rnaz << ", rlicz = " << rlicz
		<< ", a oryginalny obj (" << obj.daj_nazwe() << ", " << obj.daj_liczbe() << ")"<< endl;
}


