package eu.sig.training.r04.v4;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class AccountsTest {

    @Test
    public void testIsValidNormalCases() {
        assertTrue("isValid(\"123456789\") powinno zwrócić wartość true",
            Accounts.isValid("123456789"));
        assertFalse("isValid(\"123456788\") powinno zwrócić wartość false",
            Accounts.isValid("123456788"));
    }

    @Test
    public void testIsValidLetters() {
        assertFalse("isValid(\"abcdefghi\") powinno zwrócić wartość false",
            Accounts.isValid("ABCDEFGHK"));
    }

    @Test
    public void testIsValidNonNormal() {
        assertFalse("Pusty łańcuch nigdy nie jest prawidłową wartością", Accounts.isValid(""));
    }

    @Test
    public void testIsValidNonNumeric() {
        assertFalse("Wartości nienumeryczne są zawsze niepoprawne",
            Accounts.isValid("12.34.56."));
    }

    @Test
    public void testIsValidToolong() {
        assertFalse("Wartości składające się z więcej niż 9 cyfr są zawsze niepoprawne",
            Accounts.isValid("1234567890"));
    }

    @Test
    public void testIsValidTooshort() {
        assertFalse("Wartości składające się z mniej niż 9 cyfr są zawsze niepoprawne",
            Accounts.isValid("12345677"));
    }

}
