package eu.sig.training.r04.v2;

import eu.sig.training.r04.BusinessException;
import eu.sig.training.r04.Money;

// tag::CheckingAccount[]
public class CheckingAccount {
    private int transferLimit = 100;

    public Transfer makeTransfer(String counterAccount, Money amount)
        throws BusinessException {
        // 1. Sprawdzenie limitu wypłat
        if (amount.greaterThan(this.transferLimit)) {
            throw new BusinessException("Limit przekroczony!!!");
        }
        if (Accounts.isValid(counterAccount)) { // <1>
            // 2. Wyszukanie konta docelowego i utworzenie obiektu przelewu
            CheckingAccount acct = Accounts.findAcctByNumber(counterAccount);
            Transfer result = new Transfer(this, acct, amount); // <2>
            return result;
        } else {
            throw new BusinessException("Nieprawidłowy numer konta!!!");
        }
    }

}
// end::CheckingAccount[]
