package eu.sig.training.r05.boardpanel.v2;

import java.awt.Graphics;
import java.awt.Point;
import java.util.List;

public class BoardPanel {
    @SuppressWarnings("unused")
    // tag::render[]
    /**
     * Rysuje pojedyncze pole w podanym kontekście graficznym w określonym
     * prostokącie.
     * 
     * @param square
     *            Pole do narysowania.
     * @param g
     *            Kontekst graficzny do rysowania.
     * @param r
     *            Pozycja i wymiary do rysowania pola.
     */
    private void render(Square square, Graphics g, Rectangle r) {
        Point position = r.getPosition();
        square.getSprite().draw(g, position.x, position.y, r.getWidth(),
            r.getHeight());
        for (Unit unit : square.getOccupants()) {
            unit.getSprite().draw(g, position.x, position.y, r.getWidth(),
                r.getHeight());
        }
    }
    // end::render[]

    private class Sprite {
        @SuppressWarnings("unused")
        public void draw(Graphics g, int x, int y, int w, int h) {

        }
    }

    private class Unit {
        public Sprite getSprite() {
            return null;
        }
    }

    private class Square extends Unit {

        public List<Unit> getOccupants() {
            return null;
        }

    }
}
