package eu.sig.training.r05.boardpanel.v1;

import java.awt.Graphics;
import java.util.List;

public class BoardPanel {
    @SuppressWarnings("unused")
    // tag::render[]
    /**
     * Rysuje pojedyncze pole w podanym kontekście graficznym w określonym
     * prostokącie.
     * 
     * @param square
     *            Pole do narysowania.
     * @param g
     *            Kontekst graficzny do rysowania.
     * @param x
     *            Pozycja x do rozpoczęcia rysowania.
     * @param y
     *            Pozycja y do rozpoczęcia rysowania.
     * @param w
     *            Szerokość tego pola (w pikselach).
     * @param h
     *            Wysokość tego pola (w pikselach).
     */
    private void render(Square square, Graphics g, int x, int y, int w, int h) {
        square.getSprite().draw(g, x, y, w, h);
        for (Unit unit : square.getOccupants()) {
            unit.getSprite().draw(g, x, y, w, h);
        }
    }
    // end::render[]

    private class Sprite {
        @SuppressWarnings("unused")
        public void draw(Graphics g, int x, int y, int w, int h) {

        }
    }

    private class Unit {
        public Sprite getSprite() {
            return null;
        }
    }

    private class Square extends Unit {

        public List<Unit> getOccupants() {
            return null;
        }

    }

}
