//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION  0
#define NORMAL    1
#define TEX_COORD 2
#define TANGENT   3
#define BITANGENT 4

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora normalnego
//////////////////////////////////////////////////////////////////////
layout( location = NORMAL ) in vec3 inNormal;

//////////////////////////////////////////////////////////////////////
// wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
layout( location = TEX_COORD ) in vec2 inTexCoord;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora stycznego
//////////////////////////////////////////////////////////////////////
layout( location = TANGENT ) in vec3 inTangent;

//////////////////////////////////////////////////////////////////////
// wsprzdne wektora bistycznego
//////////////////////////////////////////////////////////////////////
layout( location = BITANGENT ) in vec3 inBitangent;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wyjciowych
//////////////////////////////////////////////////////////////////////
out Vertex
{
    // wsprzdne wierzchoka
    vec4 position;

    // wsprzdne wektora normalnego
    vec3 normal;

    // wsprzdne wektora stycznego
    vec3 tangent;

    // wsprzdne wektora bistycznego
    vec3 bitangent;

    // wsprzdne tekstury
    vec2 texCoord;
} Out;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wsprzdne wierzchoka
    Out.position = inPosition;

    // wsprzdne wektora normalnego
    Out.normal = inNormal;

    // wsprzdne wektora stycznego
    Out.tangent = inTangent;

    // wsprzdne wektora bistycznego
    Out.bitangent = inBitangent;

    // wsprzdne tekstury
    Out.texCoord = inTexCoord;
}
