//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <string>
#include <sstream>
#include <glm/glm.hpp>
#include <glm/gtc/matrix_transform.hpp>
#include <glm/gtc/type_ptr.hpp>
#include "shaders.h"

//////////////////////////////////////////////////////////////////////
// macierz rzutowania
//////////////////////////////////////////////////////////////////////
glm::mat4x4 projectionMatrix;

//////////////////////////////////////////////////////////////////////
// numeracja obiektw programu
//////////////////////////////////////////////////////////////////////
enum
{
    BEZIER,
    POINTS,
    PROGRAM_SIZE
};

//////////////////////////////////////////////////////////////////////
// identyfikatory obiektw programu
//////////////////////////////////////////////////////////////////////
GLuint program[PROGRAM_SIZE];

//////////////////////////////////////////////////////////////////////
// wsprzdne pooenia punktw kontrolnych krzywej
//////////////////////////////////////////////////////////////////////
GLfloat position [4*2] =
{
    50.0f, 50.0f,
    50.0f, 430.0f,
    430.0f, 50.0f,
    430.0f, 430.0f
};

//////////////////////////////////////////////////////////////////////
// identyfikatory obiektw bufora z danymi tablic wierzchokw
//////////////////////////////////////////////////////////////////////
GLuint vertexBuffer;

//////////////////////////////////////////////////////////////////////
// identyfikator obiektu tablic wierzchokw
//////////////////////////////////////////////////////////////////////
GLuint vertexArray;

//////////////////////////////////////////////////////////////////////
// liczba generowanych odcinkw krzywej
//////////////////////////////////////////////////////////////////////
int segments = 50;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0

//////////////////////////////////////////////////////////////////////
// funkcja generujca scen 3D
//////////////////////////////////////////////////////////////////////
void DisplayScene()
{
    // czyszczenie bufora koloru
    glClear( GL_COLOR_BUFFER_BIT );

    // wczenie obiektu tablic wierzchokw
    glBindVertexArray( vertexArray );

    // aktualizacja wsprzdnych punktw kontrolnych
    glBufferData( GL_ARRAY_BUFFER, sizeof( position ), position, GL_DYNAMIC_DRAW );

    // wczenie programu
    glUseProgram( program[BEZIER] );

    // zaadowanie zmiennej jednorodnej - iloczynu macierzy modelu-widoku i rzutowania
    // (macierz modelu-widoku nie jest generowana, poniewa jest macierz jednostkow)
    glUniformMatrix4fv( glGetUniformLocation( program[BEZIER], "modelViewProjectionMatrix" ), 1, GL_FALSE, glm::value_ptr( projectionMatrix ) );

    // zaadowanie zmiennej jednorodnej - tablicy wsprzdnych punktw kontrolnych
    glUniform2fv( glGetUniformLocation( program[BEZIER], "points" ), 4, position );

    // zaadowanie zmiennej jednorodnej - liczby generowanych odcinkw krzywej
    glUniform1i( glGetUniformLocation( program[BEZIER], "segments" ), segments );

    // narysowanie danych zawartych w tablicach wierzchokw
    glDrawArraysInstanced( GL_LINES, 0, 2, segments-1 );

    // wyczenie programu
    glUseProgram( 0 );

    // wczenie programu
    glUseProgram( program[POINTS] );

    // zaadowanie zmiennej jednorodnej - iloczynu macierzy modelu-widoku i rzutowania
    // (macierz modelu-widoku nie jest generowana, poniewa jest macierz jednostkow)
    glUniformMatrix4fv( glGetUniformLocation( program[POINTS], "modelViewProjectionMatrix" ), 1, GL_FALSE, glm::value_ptr( projectionMatrix ) );

    // narysowanie danych zawartych w tablicach wierzchokw
    glDrawArrays( GL_POINTS, 0, 4 );

    // wyczenie programu
    glUseProgram( 0 );

    // wyczenie obiektu tablic wierzchokw
    glBindVertexArray( 0 );
}

//////////////////////////////////////////////////////////////////////
// zmiana wielkoci okna
//////////////////////////////////////////////////////////////////////
void Reshape( int width, int height )
{
    // obszar renderingu - cae okno
    glViewport( 0, 0, width, height );

    // parametry bryy obcinania - rzutowanie prostoktne
    projectionMatrix = glm::ortho( 0.0f, static_cast<GLfloat>( width ), 0.0f, static_cast<GLfloat>( height ), -1.0f, 1.0f );
}

//////////////////////////////////////////////////////////////////////
// inicjalizacja staych elementw maszyny stanu OpenGL
//////////////////////////////////////////////////////////////////////
void InitScene()
{
    // kolor ta - zawarto bufora koloru
    glClearColor( 1.0f, 1.0f, 1.0f, 1.0f );

    // wczytanie shaderw i przygotowanie obsugi programu
    program[BEZIER] = glCreateProgram();
    glAttachShader( program[BEZIER], LoadShader( GL_VERTEX_SHADER, "krzywa_beziera_vs.glsl" ) );
    glAttachShader( program[BEZIER], LoadShader( GL_FRAGMENT_SHADER, "krzywa_beziera_fs.glsl" ) );
    LinkValidateProgram( program[BEZIER] );

    // wczytanie shaderw i przygotowanie obsugi programu
    program[POINTS] = glCreateProgram();
    glAttachShader( program[POINTS], LoadShader( GL_VERTEX_SHADER, "punkty_vs.glsl" ) );
    glAttachShader( program[POINTS], LoadShader( GL_FRAGMENT_SHADER, "punkty_fs.glsl" ) );
    LinkValidateProgram( program[POINTS] );

    // generowanie identyfikatora obiektu tablic wierzchokw
    glGenVertexArrays( 1, &vertexArray );

    // utworzenie obiektu tablic wierzchokw
    glBindVertexArray( vertexArray );

    // utworzenie obiektw bufora wierzchokw (VBO) i zaadowanie danych
    glGenBuffers( 1, &vertexBuffer );
    glBindBuffer( GL_ARRAY_BUFFER, vertexBuffer );
    glBufferData( GL_ARRAY_BUFFER, sizeof( position ), position, GL_DYNAMIC_DRAW );
    glVertexAttribPointer( POSITION, 2, GL_FLOAT, GL_FALSE, 0, NULL );

    // wczenie tablic wierzchokw
    glEnableVertexAttribArray( POSITION );

    // wyczenie obiektu tablic wierzchokw
    glBindVertexArray( 0 );

    // wczenie generowania wielkoci punktu w shaderze
    glEnable( GL_PROGRAM_POINT_SIZE );

    // szeroko linii
    glLineWidth( 3.0f );
}

//////////////////////////////////////////////////////////////////////
// usunicie obiektw OpenGL
//////////////////////////////////////////////////////////////////////
void DeleteScene()
{
    // porzdki
    glDeleteProgram( program[POINTS] );
    glDeleteProgram( program[BEZIER] );
    glDeleteBuffers( 1, &vertexBuffer );
    glDeleteVertexArrays( 1, &vertexArray );
}
