//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//#include <string>
#include <sstream>
#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>
#include <materials.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat scale;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateY;
extern int material;

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // klawisz +
        case '+':
            scale += 0.03f;
            break;
        // klawisz -
        case '-':
            if( scale > 0.03f ) scale -= 0.03f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        // kursor w lewo
        case GLUT_KEY_LEFT:
            translateX -= 0.03f;
            break;

        // kursor w gr
        case GLUT_KEY_UP:
            translateY += 0.03f;
            break;

        // kursor w prawo
        case GLUT_KEY_RIGHT:
            translateX += 0.03f;
            break;

        // kursor w d
        case GLUT_KEY_DOWN:
            translateY -= 0.03f;
            break;

        // nastpny materia
        case GLUT_KEY_PAGE_DOWN:
            if( material < MTL_YELLOW_RUBBER )
                material = material + 1;
            else
                material = MTL_DEFAULT;
            break;

        // poprzedni materia
        case GLUT_KEY_PAGE_UP:
            if( material > MTL_DEFAULT )
                material = material - 1;
            else
                material = MTL_YELLOW_RUBBER;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    EXIT = 50       // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // materia
        case MTL_DEFAULT:              // materia domylny
        case MTL_BRASS:                // mosidz
        case MTL_BRONZE:               // brz
        case MTL_POLISHED_BRONZE:      // polerowany brz
        case MTL_CHROME:               // chrom
        case MTL_COPPER:               // mied
        case MTL_POLISHED_COPPER:      // polerowana mied
        case MTL_GOLD:                 // zoto
        case MTL_POLISHED_GOLD:        // polerowane zoto
        case MTL_PEWTER:               // grafit (cyna z oowiem)
        case MTL_SILVER:               // srebro
        case MTL_POLISHED_SILVER:      // polerowane srebro
        case MTL_EMERALD:              // szmaragd
        case MTL_JADE:                 // jadeit
        case MTL_OBSIDIAN:             // obsydian
        case MTL_PEARL:                // pera
        case MTL_RUBY:                 // rubin
        case MTL_TURQUOISE:            // turkus
        case MTL_BRIGHT_WHITE:         // jasny biay
        case MTL_LESS_BRIGHT_WHITE:    // mniej jasny biay
        case MTL_WARMISH_WHITE:        // ciepy biay
        case MTL_COOLISH_WHITE:        // zimny biay
        case MTL_BLACK_PLASTIC:        // czarny plastik
        case MTL_CYAN_PLASTIC:         // niebieskozielony plastik
        case MTL_GREEN_PLASTIC:        // zielony plastik
        case MTL_RED_PLASTIC:          // czerwony plastik
        case MTL_WHITE_PLASTIC:        // biay plastik
        case MTL_YELLOW_PLASTIC:       // ty plastik
        case MTL_BLACK_RUBBER:         // czarna guma
        case MTL_CYAN_RUBBER:          // niebieskozielona guma
        case MTL_GREEN_RUBBER:         // zielona guma
        case MTL_RED_RUBBER:           // czerwona guma
        case MTL_WHITE_RUBBER:         // biaa guma
        case MTL_YELLOW_RUBBER:        // ta guma
            material = value;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // pobranie liczby prbek z linii polece programu
    int samples = 4;
    if( argc > 1 )
        std::istringstream( argv[1] ) >> samples;

    // ustawienie liczby prbek w wieloprbkowaniu
    glutSetOption( GLUT_MULTISAMPLE, samples );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH | GLUT_MULTISAMPLE );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 4, 0 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "Wieloprbkowanie na prbk" );
#else
    glutCreateWindow( "Wieloprobkowanie na probke" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_4_0 )
    {
        std::cout << "Brak OpenGL 4.0" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie podmenu "Materia"
    int menuMaterial = glutCreateMenu( Menu );
    glutAddMenuEntry( "default", MTL_DEFAULT );
    glutAddMenuEntry( "Brass", MTL_BRASS );
    glutAddMenuEntry( "Bronze", MTL_BRONZE );
    glutAddMenuEntry( "Polished Bronze", MTL_POLISHED_BRONZE );
    glutAddMenuEntry( "Chrome", MTL_CHROME );
    glutAddMenuEntry( "Copper", MTL_COPPER );
    glutAddMenuEntry( "Polished Copper", MTL_POLISHED_COPPER );
    glutAddMenuEntry( "Gold", MTL_GOLD );
    glutAddMenuEntry( "Polished Gold", MTL_POLISHED_GOLD );
    glutAddMenuEntry( "Pewter", MTL_PEWTER );
    glutAddMenuEntry( "Silver", MTL_SILVER );
    glutAddMenuEntry( "Polished Silver", MTL_POLISHED_SILVER );
    glutAddMenuEntry( "Emerald", MTL_EMERALD );
    glutAddMenuEntry( "Jade", MTL_JADE );
    glutAddMenuEntry( "Obsidian", MTL_OBSIDIAN );
    glutAddMenuEntry( "Pearl", MTL_PEARL );
    glutAddMenuEntry( "Ruby", MTL_RUBY );
    glutAddMenuEntry( "Turquoise", MTL_TURQUOISE );
    glutAddMenuEntry( "Bright White", MTL_BRIGHT_WHITE );
    glutAddMenuEntry( "Less Bright White", MTL_LESS_BRIGHT_WHITE );
    glutAddMenuEntry( "Warmish White", MTL_WARMISH_WHITE );
    glutAddMenuEntry( "Coolish White", MTL_COOLISH_WHITE );
    glutAddMenuEntry( "Black Plastic", MTL_BLACK_PLASTIC );
    glutAddMenuEntry( "Cyan Plastic", MTL_CYAN_PLASTIC );
    glutAddMenuEntry( "Green Plastic", MTL_GREEN_PLASTIC );
    glutAddMenuEntry( "Red Plastic", MTL_RED_PLASTIC );
    glutAddMenuEntry( "White Plastic", MTL_WHITE_PLASTIC );
    glutAddMenuEntry( "Yellow Plastic", MTL_YELLOW_PLASTIC );
    glutAddMenuEntry( "Black Rubber", MTL_BLACK_RUBBER );
    glutAddMenuEntry( "Cyan Rubber", MTL_CYAN_RUBBER );
    glutAddMenuEntry( "Green Rubber", MTL_GREEN_RUBBER );
    glutAddMenuEntry( "Red Rubber", MTL_RED_RUBBER );
    glutAddMenuEntry( "White Rubber", MTL_WHITE_RUBBER );
    glutAddMenuEntry( "Yellow Rubber", MTL_YELLOW_RUBBER );

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddSubMenu( "Material", menuMaterial );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
