//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// parametry teselacji
//////////////////////////////////////////////////////////////////////
layout( isolines, equal_spacing, ccw ) in;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// macierz bazowa wspczynnikw rwnania krzywej Bziera
//////////////////////////////////////////////////////////////////////
mat4 base = mat4( -1.0, 3.0, -3.0, 1.0,
                   3.0, -6.0, 3.0, 0.0,
                  -3.0, 3.0, 0.0, 0.0,
                   1.0, 0.0, 0.0, 0.0 );

//////////////////////////////////////////////////////////////////////
// macierz utworzona ze wsprzdnych punktw
// kontrolnych rwnania krzywej Bziera
//////////////////////////////////////////////////////////////////////
mat4 m = mat4( gl_in[0].gl_Position,
               gl_in[1].gl_Position,
               gl_in[2].gl_Position,
               gl_in[3].gl_Position );

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // wsprzdne liniowe wierzchoka prymitywu
    float t = gl_TessCoord.x;

    // wektor wspczynnikw rwnania krzywej Bziera
    vec4 tvec = vec4( t*t*t, t*t, t, 1 );

    // obliczenie wsprzdnych jednorodnych punktu krzywej
    gl_Position = modelViewProjectionMatrix * m * base * tvec;
}
