//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 3.30
//////////////////////////////////////////////////////////////////////
#version 330

//////////////////////////////////////////////////////////////////////
// wektory przesuni poszczeglnych instancji obiektu
//////////////////////////////////////////////////////////////////////
const vec4 translate[16] = vec4[16]
(
    vec4( -1.5, 0.0, 1.5, 0.0 ),
    vec4( -1.5, 0.0, -1.5, 0.0 ),
    vec4( 1.5, 0.0, -1.5, 0.0 ),
    vec4( 1.5, 0.0, 1.5, 0.0 ),
    vec4( -0.5, 0.0, 0.5, 0.0 ),
    vec4( -0.5, 0.0, -0.5, 0.0 ),
    vec4( 0.5, 0.0, -0.5, 0.0 ),
    vec4( 0.5, 0.0, 0.5, 0.0 ),
    vec4( -1.5, 0.0, 0.5, 0.0 ),
    vec4( -1.5, 0.0, -0.5, 0.0 ),
    vec4( 1.5, 0.0, -0.5, 0.0 ),
    vec4( 1.5, 0.0, 0.5, 0.0 ),
    vec4( -0.5, 0.0, 1.5, 0.0 ),
    vec4( -0.5, 0.0, -1.5, 0.0 ),
    vec4( 0.5, 0.0, -1.5, 0.0 ),
    vec4( 0.5, 0.0, 1.5, 0.0 )
);

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// numery indeksw poszczeglnych atrybutw wierzchokw
//////////////////////////////////////////////////////////////////////
#define POSITION 0
#define COLOR 2

//////////////////////////////////////////////////////////////////////
// wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = POSITION ) in vec4 inPosition;

//////////////////////////////////////////////////////////////////////
// kolor wierzchoka
//////////////////////////////////////////////////////////////////////
layout( location = COLOR ) in vec4 inColor;

//////////////////////////////////////////////////////////////////////
// interpolowany kolor wierzchoka
//////////////////////////////////////////////////////////////////////
out vec4 inoutColor;

void main()
{
    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * (inPosition + translate[gl_InstanceID]);

    // kolor wierzchoka do interpolacji
    inoutColor = inColor;
}
