//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// dwuwymiarowa tekstura wieloprbkowania
//////////////////////////////////////////////////////////////////////
uniform sampler2DMS tex;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// liczba prbek w teksturze
//////////////////////////////////////////////////////////////////////
uniform int samples = 4;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // pocztkowy kolor fragmentu
    outColor = vec4( 0.0 );

    // wsprzdne pobieranych prbek tekstury
    ivec2 pos = ivec2( inoutTexCoord * textureSize( tex ) );

    // sumowanie wartoci wszystkich prbek
    for( int i = 0; i < samples; i++ )
        outColor += texelFetch( tex, pos, i );

    // normalizacja wartoci sumy wszystkich prbek
    outColor /= samples;
}
