//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

#include <iostream>
#include <GL/glew.h>
#include <GL/freeglut.h>

//////////////////////////////////////////////////////////////////////
// deklaracje funkcji obsugujcych rendering w OpenGL
//////////////////////////////////////////////////////////////////////
void DisplayScene();
void Reshape( int width, int height );
void InitScene();
void DeleteScene();

//////////////////////////////////////////////////////////////////////
// nazwa pliku podana w wierszu polecenia
//////////////////////////////////////////////////////////////////////
extern char *fileName;

//////////////////////////////////////////////////////////////////////
// zmienne niezbdne do obsugi ruchu myszy i klawiatury
//////////////////////////////////////////////////////////////////////
extern GLfloat left;
extern GLfloat right;
extern GLfloat bottom;
extern GLfloat top;
extern GLfloat scale;
extern GLfloat rotateX;
extern GLfloat rotateY;
extern GLfloat translateX;
extern GLfloat translateY;
extern GLfloat rotateLightX;
extern GLfloat rotateLightY;
extern int lightType;
enum
{
    PHONG_LIGHT,
    BLINN_PHONG_LIGHT,
    LAMBERT_LIGHT,
    PHONG_LIGHT_NORMAL_MAP,
    BLINN_PHONG_LIGHT_NORMAL_MAP,
    LAMBERT_LIGHT_NORMAL_MAP
};

//////////////////////////////////////////////////////////////////////
// wskanik nacinicia lewego przycisku myszy
//////////////////////////////////////////////////////////////////////
int buttonState = GLUT_UP;

//////////////////////////////////////////////////////////////////////
// pooenie kursora myszy
//////////////////////////////////////////////////////////////////////
int buttonX, buttonY;

//////////////////////////////////////////////////////////////////////
// obsuga przyciskw myszy
//////////////////////////////////////////////////////////////////////
void MouseButton( int button, int state, int x, int y )
{
    if( button == GLUT_LEFT_BUTTON )
    {
        // zapamitanie stanu lewego przycisku myszy
        buttonState = state;

        // zapamitanie pooenia kursora myszy
        if( state == GLUT_DOWN )
        {
            buttonX = x;
            buttonY = y;
        }
    }
}

//////////////////////////////////////////////////////////////////////
// obsuga ruchu kursora myszy
//////////////////////////////////////////////////////////////////////
void MouseMotion( int x, int y )
{
    if( buttonState == GLUT_DOWN )
    {
        rotateY += 30 *(right - left) / glutGet( GLUT_WINDOW_WIDTH ) * (x - buttonX);
        buttonX = x;
        rotateX -= 30 *(top - bottom) / glutGet( GLUT_WINDOW_HEIGHT ) * (buttonY - y);
        buttonY = y;
        glutPostRedisplay();
    }
}

//////////////////////////////////////////////////////////////////////
// stae do obsugi menu kontekstowego
//////////////////////////////////////////////////////////////////////
enum
{
    EXIT = 10   // wyjcie
};

//////////////////////////////////////////////////////////////////////
// obsuga menu kontekstowego
//////////////////////////////////////////////////////////////////////
void Menu( int value )
{
    switch( value )
    {
        // owietlenie
        case PHONG_LIGHT:
        case BLINN_PHONG_LIGHT:
        case LAMBERT_LIGHT:
        case PHONG_LIGHT_NORMAL_MAP:
        case BLINN_PHONG_LIGHT_NORMAL_MAP:
        case LAMBERT_LIGHT_NORMAL_MAP:
            lightType = value;
            break;

        // wyjcie
        case EXIT:
            exit( 0 );
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiatury
//////////////////////////////////////////////////////////////////////
void Keyboard( unsigned char key, int x, int y )
{
    switch( key )
    {
        // q
        case 'Q':
        case 'q':
            rotateLightX += 1.0f;
            break;
        // a
        case 'A':
        case 'a':
            rotateLightX -= 1.0f;
            break;
        // w
        case 'W':
        case 'w':
            rotateLightY += 1.0f;
            break;
        // s
        case 'S':
        case 's':
            rotateLightY -= 1.0f;
            break;
        // klawisz +
        case '+':
            scale += 0.03f;
            break;
        // klawisz -
        case '-':
            if( scale > 0.03f ) scale -= 0.03f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga klawiszy funkcyjnych i klawiszy kursora
//////////////////////////////////////////////////////////////////////
void SpecialKeys( int key, int x, int y )
{
    switch( key )
    {
        // kursor w lewo
        case GLUT_KEY_LEFT:
            translateX -= 0.03f;
            break;

        // kursor w gr
        case GLUT_KEY_UP:
            translateY += 0.03f;
            break;

        // kursor w prawo
        case GLUT_KEY_RIGHT:
            translateX += 0.03f;
            break;

        // kursor w d
        case GLUT_KEY_DOWN:
            translateY -= 0.03f;
            break;
    }

    // odrysowanie okna
    glutPostRedisplay();
}

//////////////////////////////////////////////////////////////////////
// obsuga renderingu sceny 3D i zamiany buforw renderingu
//////////////////////////////////////////////////////////////////////
void Display()
{
    // rendering sceny
    DisplayScene();

    // sprawdzenie bdw
    GLenum error = glGetError();
    switch( error )
    {
        case GL_CONTEXT_LOST:
            std::cout << "GL_CONTEXT_LOST" << std::endl;
            exit( 1 );
        case GL_INVALID_ENUM:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_VALUE:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_INVALID_FRAMEBUFFER_OPERATION:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_OUT_OF_MEMORY:
            std::cout << "GL_INVALID_ENUM" << std::endl;
            exit( 1 );
        case GL_STACK_OVERFLOW:
            std::cout << "GL_STACK_OVERFLOW" << std::endl;
            exit( 1 );
        case GL_STACK_UNDERFLOW:
            std::cout << "GL_STACK_UNDERFLOW" << std::endl;
            exit( 1 );
        case GL_NO_ERROR:
            break;
    }

    // zamiana buforw koloru
    glutSwapBuffers();
}

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
    // pobranie nazwy pliku do wywietlenia
    fileName = argv[1];

    // inicjalizacja biblioteki FreeGLUT
    glutInit( &argc, argv );

    // inicjalizacja bufora ramki
    glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH | GLUT_ALPHA );

    // utworzenie kontekstu renderingu OpenGL
    glutInitContextVersion( 4, 3 );
    glutInitContextProfile( GLUT_CORE_PROFILE );

    // rozmiary gwnego okna programu
    glutInitWindowSize( 500, 500 );

    // utworzenie gwnego okna programu
#ifdef WIN32
    glutCreateWindow( "Mapowanie wektorw normalnych" );
#else
    glutCreateWindow( "Mapowanie wektorow normalnych" );
#endif // WIN32

    // inicjalizacja biblioteki GLEW
    glewExperimental = GL_TRUE;
    GLenum err = glewInit();
    if( GLEW_OK != err )
    {
        std::cout << "Niepoprawna inicjalizacja biblioteki GLEW" << std::endl;
        return 1;
    }

    // sprawdzenie dostpnoci wybranej wersji OpenGL
    if( !GLEW_VERSION_4_3 )
    {
        std::cout << "Brak OpenGL 4.3" << std::endl;
        return 1;
    }
    glGetError();

    // utworzenie menu kontekstowego
    glutCreateMenu( Menu );

    // dodanie pozycji do menu kontekstowego
    glutAddMenuEntry( "Oswietlenie Phonga", PHONG_LIGHT );
    glutAddMenuEntry( "Oswietlenie Blinna-Phonga", BLINN_PHONG_LIGHT );
    glutAddMenuEntry( "Oswietlenie Lamberta", LAMBERT_LIGHT );
    glutAddMenuEntry( "Oswietlenie Phonga z mapowaniem wektorow normalnych", PHONG_LIGHT_NORMAL_MAP );
    glutAddMenuEntry( "Oswietlenie Blina-Phonga z mapowaniem wektorow normalnych", BLINN_PHONG_LIGHT_NORMAL_MAP );
    glutAddMenuEntry( "Oswietlenie Lamberta z mapowaniem wektorow normalnych", LAMBERT_LIGHT_NORMAL_MAP );
    glutAddMenuEntry( "Wyjscie", EXIT );

    // okrelenie przycisku myszy obsugujcego menu kontekstowe
    glutAttachMenu( GLUT_RIGHT_BUTTON );

    // obsuga przyciskw myszy
    glutMouseFunc( MouseButton );

    // obsuga ruchu kursora myszy
    glutMotionFunc( MouseMotion );

    // obsuga klawiatury
    glutKeyboardFunc( Keyboard );

    // inicjalizacja elementw sceny 3D
    InitScene();

    // doczenie funkcji generujcej scen 3D
    glutDisplayFunc( Display );

    // obsuga klawiszy funkcyjnych i klawiszy kursora
    glutSpecialFunc( SpecialKeys );

    // doczenie funkcji wywoywanej przy zmianie rozmiaru okna
    glutReshapeFunc( Reshape );

    // obsuga ptli komunikatw
    glutMainLoop();

    // usunicie elementw sceny 3D
    DeleteScene();

    // koniec
    return 0;
}
