//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// parametry teselacji
//////////////////////////////////////////////////////////////////////
layout( quads, equal_spacing, ccw ) in;

//////////////////////////////////////////////////////////////////////
// iloczyn macierzy modelu-widoku i macierzy rzutowania
//////////////////////////////////////////////////////////////////////
uniform mat4 modelViewProjectionMatrix;

//////////////////////////////////////////////////////////////////////
// interpolowany wektor normalny
//////////////////////////////////////////////////////////////////////
out vec3 inoutNormal;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne wierzchoka
//////////////////////////////////////////////////////////////////////
out vec3 inoutPosition;

//////////////////////////////////////////////////////////////////////
// bazowa macierz przeksztacenia
//////////////////////////////////////////////////////////////////////
const mat4 base = mat4( -1.0,  3.0, -3.0, 1.0,
                         3.0, -6.0,  3.0, 0.0,
                        -3.0,  3.0,  0.0, 0.0,
                         1.0,  0.0,  0.0, 0.0 );

//////////////////////////////////////////////////////////////////////
// rozmiar zbioru punktw kontrolnych
//////////////////////////////////////////////////////////////////////
#define PATCH_SIZE 16

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // tablica punktw kontrolnych biecej paszczyzny
    vec4 p[PATCH_SIZE];

    // zaadowanie wsprzdnych punktw kontrolnych
    for( int i = 0; i < PATCH_SIZE; i++ )
        p[i] = gl_in[i].gl_Position;

    // macierze przeksztace poszczeglnych skadowych wsprzdnych
    mat4 mx = mat4(  p[0].x,  p[1].x,  p[2].x,  p[3].x,
                     p[4].x,  p[5].x,  p[6].x,  p[7].x,
                     p[8].x,  p[9].x, p[10].x, p[11].x,
                    p[12].x, p[13].x, p[14].x, p[15].x );
    mat4 my = mat4(  p[0].y,  p[1].y,  p[2].y,  p[3].y,
                     p[4].y,  p[5].y,  p[6].y,  p[7].y,
                     p[8].y,  p[9].y, p[10].y, p[11].y,
                    p[12].y, p[13].y, p[14].y, p[15].y );
    mat4 mz = mat4(  p[0].z,  p[1].z,  p[2].z,  p[3].z,
                     p[4].z,  p[5].z,  p[6].z,  p[7].z,
                     p[8].z,  p[9].z, p[10].z, p[11].z,
                    p[12].z, p[13].z, p[14].z, p[15].z );
    mat4 mw = mat4( 1.0, 1.0, 1.0, 1.0,
                    1.0, 1.0, 1.0, 1.0,
                    1.0, 1.0, 1.0, 1.0,
                    1.0, 1.0, 1.0, 1.0 );

    // wektor wartoci parametrw uv powierzchni
    vec2 uv = gl_TessCoord.xy;

    // obliczenie wsprzdnych punktu powierzchni
    vec4 u = vec4( uv.x * uv.x * uv.x, uv.x * uv.x, uv.x, 1.0 );
    vec4 v = vec4( uv.y * uv.y * uv.y, uv.y * uv.y, uv.y, 1.0 );
    vec4 position = v * mat4( u * base * mx * base,
                              u * base * my * base,
                              u * base * mz * base,
                              u * base * mw * base );

    // obliczenie pochodnych czstkowych
    vec4 du = vec4( 3 * uv.x * uv.x, 2 * uv.x, 1.0, 0.0 );
    vec4 dv = vec4( 3 * uv.y * uv.y, 2 * uv.y, 1.0, 0.0 );

    // obliczenie wektorw stycznych do powierzchni
    vec4 t = v * mat4( du * base * mx * base,
                       du * base * my * base,
                       du * base * mz * base,
                       du * base * mw * base );
    vec4 b = dv * mat4( u * base * mx * base,
                        u * base * my * base,
                        u * base * mz * base,
                        u * base * mw * base );

    // obliczenie, przeksztacenie i normalizacja wektora normalnego
    inoutNormal = cross( t.xyz, b.xyz );
    inoutNormal = length( inoutNormal ) != 0 ? normalize( inoutNormal ) : vec3( 1.0, 0.0, 0.0 );

    // standardowe przeksztacenie wsprzdnych wierzchokw
    gl_Position = modelViewProjectionMatrix * position;

    // wsprzdne wierzchoka do interpolacji
    inoutPosition = position.xyz;
}
