//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 4.00
//////////////////////////////////////////////////////////////////////
#version 400

//////////////////////////////////////////////////////////////////////
// struktura opisujca parametry materiau
//////////////////////////////////////////////////////////////////////
struct MaterialParameters
{
    vec4 ambient;       // wspczynnik odbicia wiata otoczenia; oznaczenie Ma
    vec4 diffuse;       // wspczynnik odbicia wiata rozproszonego; oznaczenie Md
    vec4 specular;      // wspczynnik odbicia wiata zwierciadlanego; oznaczenie Ms
    float shininess;    // wykadnik wspczynnika funkcji rozbysku;
                        // zakres wartoci <0;128>; oznaczenie Msh
};

//////////////////////////////////////////////////////////////////////
// prototypy funkcji
//////////////////////////////////////////////////////////////////////
MaterialParameters GetMaterial( const int material );
vec4 BlinnPhongLight( const int light, const vec3 normal, const vec3 position,
                        const vec4 ambient, const vec4 diffuse,
                        const vec4 specular, const float shininess );

//////////////////////////////////////////////////////////////////////
// wybrany materia
//////////////////////////////////////////////////////////////////////
uniform int material;

//////////////////////////////////////////////////////////////////////
// blok zmiennych wejciowych
//////////////////////////////////////////////////////////////////////
in Vertex
{
    // wsprzdne wierzchoka
    sample vec3 position;

    // wsprzdne wektora normalnego
    sample vec3 normal;
} In;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

void main()
{
    // pobranie wartoci pokrycia biecej prbki
    int mask = bitfieldExtract( gl_SampleMaskIn[gl_SampleID/32], gl_SampleID % 32, 1 ) == 0 ? 0 : 1;

    // zapis wartoci pokrycia biecej prbki
    gl_SampleMask[gl_SampleID/32] = bitfieldInsert( gl_SampleMaskIn[gl_SampleID/32], mask, gl_SampleID % 32, 1 );

    // kolor prbki okrelamy tylko wtedy, gdy prbka podlega przetwarzaniu
    if( mask > 0)
    {
        // normalizacja wektora normalnego zalena od strony wielokta
        vec3 normal = gl_FrontFacing ? normalize( In.normal ) : -normalize( In.normal );

        // pobranie wybranego materiau
        MaterialParameters mat = GetMaterial( material );

        // kolor prbki
        outColor = BlinnPhongLight( 0, normal, In.position, mat.ambient, mat.diffuse, mat.specular, mat.shininess );
    }
}
