//////////////////////////////////////////////////////////////////////
// (c) Janusz Ganczarski
// http://www.januszg.hg.pl
// JanuszG@enter.net.pl
//////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// GLSL 1.50
//////////////////////////////////////////////////////////////////////
#version 150

//////////////////////////////////////////////////////////////////////
// prototyp funkcji zwracajcej mask filtra 33
//////////////////////////////////////////////////////////////////////
mat3x3 Filter3x3( const int filter );

//////////////////////////////////////////////////////////////////////
// uchwyt tekstury 2D
//////////////////////////////////////////////////////////////////////
uniform sampler2D tex;

//////////////////////////////////////////////////////////////////////
// rodzaj filtra
//////////////////////////////////////////////////////////////////////
uniform int filterType;

//////////////////////////////////////////////////////////////////////
// interpolowane wsprzdne tekstury
//////////////////////////////////////////////////////////////////////
in vec2 inoutTexCoord;

//////////////////////////////////////////////////////////////////////
// wyjciowy kolor fragmentu
//////////////////////////////////////////////////////////////////////
out vec4 outColor;

//////////////////////////////////////////////////////////////////////
// program gwny
//////////////////////////////////////////////////////////////////////
void main()
{
    // pocztkowy kolor wynikowy operacji splotu
    outColor = vec4( 0.0 );

    // maska filtra
    mat3x3 filter = Filter3x3( filterType );

    // obliczenie wartoci skadowych teksela po filtracji
    outColor += mat3x4( textureOffset( tex, inoutTexCoord, ivec2( -1, -1 ) ),
                        textureOffset( tex, inoutTexCoord, ivec2(  0, -1 ) ),
                        textureOffset( tex, inoutTexCoord, ivec2(  1, -1 ) ) ) * filter[0];
    outColor += mat3x4( textureOffset( tex, inoutTexCoord, ivec2( -1,  0 ) ),
                        textureOffset( tex, inoutTexCoord, ivec2(  0,  0 ) ),
                        textureOffset( tex, inoutTexCoord, ivec2(  1,  0 ) ) ) * filter[1];
    outColor += mat3x4( textureOffset( tex, inoutTexCoord, ivec2( -1,  1 ) ),
                        textureOffset( tex, inoutTexCoord, ivec2(  0,  1 ) ),
                        textureOffset( tex, inoutTexCoord, ivec2(  1,  1 ) ) ) * filter[2];
}
