#version 430 core

// Próbki dla zrenderowanego wcześniej koloru, głębi i normalnej.
layout (binding = 0) uniform sampler2D sColor;
layout (binding = 1) uniform sampler2D sNormalDepth;

// Wyjście.
layout (location = 0) out vec4 color;

// Rożne zmienne uniform sterujące efektem SSAO.
uniform float ssao_level = 1.0;
uniform float object_level = 1.0;
uniform float ssao_radius = 5.0;
uniform bool weight_by_angle = true;
uniform uint point_count = 8;
uniform bool randomize_points = true;

// Blok uniform zawierający do 256 losowych kierunków (x,y,z,0)
// i 256 całkowicie losowych wektorów.
layout (binding = 0, std140) uniform SAMPLE_POINTS
{
    vec4 pos[256];
    vec4 random_vectors[256];
} points;

void main(void)
{
    // Pobierz położenie tekstury z gl_FragCoord.
    vec2 P = gl_FragCoord.xy / textureSize(sNormalDepth, 0);
    // ND = normalna i głębia
    vec4 ND = textureLod(sNormalDepth, P, 0);
    // Wydobądź normalną i głębię.
    vec3 N = ND.xyz;
    float my_depth = ND.w;

    // Lokalne zmienne tymczasowe.
    int i;
    int j;
    int n;

    float occ = 0.0;
    float total = 0.0;

    // Zmienna n to liczba pseudolosowa wygenerowana na podstawie współrzędnych fragmentu i głębi.
    n = (int(gl_FragCoord.x * 7123.2315 + 125.232) *
         int(gl_FragCoord.y * 3137.1519 + 234.8)) ^
         int(my_depth);
    // Pobierz jeden z losowych wektorów.
    vec4 v = points.random_vectors[n & 255];

    // Zmienna r to sposób na losowość promienia.
    float r = (v.r + 3.0) * 0.1;
    if (!randomize_points)
        r = 0.5;

    // Dla każdego losowego punktu (lub kierunku)...
    for (i = 0; i < point_count; i++)
    {
        // Pobierz kierunek.
        vec3 dir = points.pos[i].xyz;

        // Umieść go na właściwej półkuli.
        if (dot(N, dir) < 0.0)
            dir = -dir;

        // Zmienna f to odległość kroku w danym kierunku.
        // Zmienna z to interpolowana głębia.
        float f = 0.0;
        float z = my_depth;

        // Wykonamy cztery kroki; wartość może być konfigurowalna.
        total += 4.0;

        for (j = 0; j < 4; j++)
        {
            // Krok we właściwym kierunku.
            f += r;
            // Krok w stronę widza zmniejsza z.
            z -= dir.z * f;

            // Odczytaj głębię aktualnego fragmentu.
            float their_depth =
                textureLod(sNormalDepth,
                           (P + dir.xy * f * ssao_radius), 0).w;

            // Obliczenie wagi (d) tego fragmentu w okluzji.
            float d = abs(their_depth - my_depth);
            d *= d;

            // Jesteśmy zasłonięci, akumuluj okluzję.
            if ((z - their_depth) > 0.0)
            {
                occ += 4.0 / (1.0 + d);
            }
        }
    }

    // Oblicz wartość okluzji.
    float ao_amount = (1.0 - occ / total);

    // Pobierz kolor obiektu z tekstury.
    vec4 object_color =  textureLod(sColor, P, 0);

    // Zmieszaj kolor otoczenia na podstawie poziomu SSAO.
    color = object_level * object_color +
            mix(vec4(0.2), vec4(ao_amount), ssao_level);
}
