#version 410 core

// Ten wektor wejciowy zawiera pooenia wierzchokw
// w skadowych xyz oraz mas wierzchoka w skadowej w.
layout (location = 0) in vec4 position_mass;
// To aktualna prdko wierzchoka.
layout (location = 1) in vec3 velocity;
// To wektor poczenia.
layout (location = 2) in ivec4 connection;

// To TBO, ktry zostanie powizany z tym samym buforem
// co atrybut wejciowy position_mass.
uniform samplerBuffer tex_position;

// Wyjcie shadra wierzchokw jest takie samo jak wejcie.
out vec4 tf_position_mass;
out vec3 tf_velocity;

// Uniform przechowujcy krok czasowy. Aplikacja moe go aktualizowa.
uniform float t = 0.07;

// Globalna staa spryny.
uniform float k = 7.1;

// Grawitacja.
const vec3 gravity = vec3(0.0, -0.08, 0.0);

// Globalna staa tarcia.
uniform float c = 2.8;

// Dugo spoczynkowa spryny.
uniform float rest_length = 0.88;

void main(void)
{
    vec3 p = position_mass.xyz;    // p to nasza pozycja
    float m = position_mass.w;     // m to masa wierzchoka
    vec3 u = velocity;             // u to prdko pocztkowa
    vec3 F = gravity * m - c * u;  // F to sia przykadana do masy
    bool fixed_node = true;        // Ma warto false, jeli sia jest przykadana.

    for (int i = 0; i < 4; i++) {
        if (connection[i] != -1) {
            // q to pooenie innego wierzchoka
            vec3 q = texelFetch(tex_position, connection[i]).xyz;
            vec3 d = q - p;
            float x = length(d);
            F += -k * (rest_length - x) * normalize(d);
            fixed_node = false;
        }
    }

    // To stay wze, wic ustaw si na 0.
    if (fixed_node)
    {
        F = vec3(0.0);
    }

    // Przyspieszenie wynikajce z siy.
    vec3 a = F / m;

    // Przemieszczenie.
    vec3 s = u * t + 0.5 * a * t * t;

    // Prdko kocowa.
    vec3 v = u + a * t;

    // Ogranicz warto absolutn przemieszczenia stosowan w jednym kroku.
    s = clamp(s, vec3(-25.0), vec3(25.0));

    // Zapisz dane wyjciowe.
    tf_position_mass = vec4(p + s, m);
    tf_velocity = v;
}
