#version 420 core

// Wyjście.
layout (location = 0) out vec4 color;

// Tekstura.
layout (binding = 0) uniform sampler2D tex;

// Wejścia z shadera wierzchołków.
in VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
    vec2 tc;
} fs_in;

// Właściwości materiału.
const vec3 diffuse_albedo = vec3(0.5, 0.5, 0.9);
const vec3 specular_albedo = vec3(0.7);
const float specular_power = 300.0;

void main(void)
{
    // Normalizacja nadchodzących wektorów N, L i V.
    vec3 N = normalize(fs_in.N);
    vec3 L = normalize(fs_in.L);
    vec3 V = normalize(fs_in.V);
    vec3 H = normalize(L + V);

    // Oblicz komponenty odbicia i rozproszenia dla każdego fragmentu.
    vec3 diffuse = max(dot(N, L), 0.0) * diffuse_albedo;
    vec3 specular = pow(max(dot(N, H), 0.0), specular_power) * specular_albedo;

    // Zapisz finalny kolor do bufora ramki.
    float factor = texture(tex, fs_in.tc).x;
    vec4 lit = vec4(mix(diffuse, diffuse.yzx, factor)+ specular, 1.0);
    color = lit;
}
