#version 420 core

layout (location = 0) out vec4 color;

in VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
} fs_in;

// Właściwości materiału.
uniform vec3 diffuse_albedo = vec3(0.9, 0.8, 1.0);
uniform vec3 specular_albedo = vec3(0.3);
uniform float specular_power = 25.0;
uniform bool full_shading = true;

void main(void)
{
    // Normalizacja nadchodzących wektorów N, L i V.
    vec3 N = normalize(fs_in.N);
    vec3 L = normalize(fs_in.L);
    vec3 V = normalize(fs_in.V);

    // Obliczenie R lokalnie.
    vec3 R = reflect(-L, N);

    // Oblicz komponenty odbicia i rozproszenia dla każdego fragmentu.
    vec3 diffuse = max(dot(N, L), 0.0) * diffuse_albedo;
    vec3 specular = pow(max(dot(R, V), 0.0), specular_power) * specular_albedo;

    // Zapisz finalny kolor do bufora ramki.
    color = vec4(diffuse + specular, 1.0);
}
