#version 410 core

// Wyjcie.
layout (location = 0) out vec4 color;

// Wejcie z shadera wierzchokw.
in VS_OUT
{
    vec3 N;
    vec3 L;
    vec3 V;
} fs_in;

// Waciwoci materiau.
uniform vec3 diffuse_albedo = vec3(0.5, 0.2, 0.7);
uniform vec3 specular_albedo = vec3(0.7);
uniform float specular_power = 128.0;
uniform vec3 ambient = vec3(0.1, 0.1, 0.1);

void main(void)
{
    // Normalizacja uzyskanych wektorw N, L i V.
    vec3 N = normalize(fs_in.N);
    vec3 L = normalize(fs_in.L);
    vec3 V = normalize(fs_in.V);

    // Obliczenie R lokalnie.
    vec3 R = reflect(-L, N);

    // Obliczenie wspczynnikw rozproszenia i odbicia dla kadego fragmentu.
    vec3 diffuse = max(dot(N, L), 0.0) * diffuse_albedo;
    vec3 specular = pow(max(dot(R, V), 0.0), specular_power) * specular_albedo;

    // Zapis kocowego koloru do bufora ramki.
    color = vec4(ambient + diffuse + specular, 1.0);
}
