//Listing 9.3. Utworzenie przełącznika przy użyciu suwaka. Program ten odtwarza film wideo i przełącznik służy w nim do wstrzymywania i wznawiania odtwarzania
//
// An example program in which the user can draw boxes on the screen.
//
#include <opencv2/opencv.hpp>
#include <iostream>
using namespace std;
//
// utworzenie z suwaka przełącznika, za pomocą którego użytkownik może włączać i wyłączać odtwarzanie
// wartość ta jest globalna, aby była wszędzie widoczna
//
int g_switch_value = 1;
void switch_off_function() { cout << "Wstrzymaj\n"; }; // MOŻNA ZROBIĆ WIĘCEJ
void switch_on_function()  { cout << "Odtwarzaj\n"; };

// to jest funkcja zwrotna, którą przypiszemy suwakowi
//
void switch_callback( int position, void* ) {
  if( position == 0 ) {
    switch_off_function();
  } else {
    switch_on_function();
  }
}

void help(char ** argv) {
    cout << "Listing 9.3. Utworzenie przełącznika przy użyciu suwaka."
         << "\n Program ten odtwarza film wideo i przełącznik służy w nim do wstrzymywania i wznawiania odtwarzania."
         << "\n\nWywołanie:\n" << argv[0] << " <path/video_file>"
		 << "\n\nPokazuje przycisk wstrzymujący odtwarzanie filmu; Esc zamyka program.\n" << endl;
}

int main( int argc, char** argv ) {
  cv::Mat frame; // do przechowywania obrazów filmu
  cv::VideoCapture g_capture;
  help(argv);
  if( argc < 2 || !g_capture.open( argv[1] ) ){
    cout << "Nie udało się otworzyć pliku wideo " << argv[1] << "\n" << endl;
    return -1;
  }

  // nazwa okna głównego
  //
  cv::namedWindow( "Example", 1 );

  // utworzenie suwaka, któremu nadajemy nazwę i podajemy nazwę okna nadrzędnego
  //
  cv::createTrackbar(
    "Switch",
    "Example",
    &g_switch_value,
    1,
    switch_callback
  );

  // to spowoduje oczekiwanie przez OpenCV w bezczynności na naciśnięcie przycisku Esc
  //
  for(;;) {
    if( g_switch_value ) {
          g_capture >> frame;
          if( frame.empty() ) break;
          cv::imshow( "Example", frame);
      }
      if( cv::waitKey(10)==27 ) break; // esc
  }
  return 0;

}
