// Listing 9.2. Prosty program, w ktrym za pomoc myszy mona rysowa prostokty na ekranie
#include <opencv2/opencv.hpp>

// definicja funkcji zwrotnej, ktr zainstalujemy dla zdarze myszy
//
void my_mouse_callback(

  int event, int x, int y, int flags, void* param
);
cv::Rect box;
bool drawing_box = false;


// maa podprocedura rysujca prostokt na obrazie
//
void draw_box( cv::Mat& img, cv::Rect box ) {
  cv::rectangle(
    img,
    box.tl(),
    box.br(),

    cv::Scalar(0x00,0x00,0xff)    /* red */
  );
}
void help(char** argv) {
  std::cout << "Listing 9.2. Prosty program, w ktrym za pomoc myszy mona rysowa prostokty na ekranie"
     << "\nWywoanie:\n" << argv[0] <<
    "\n\npokazuje, jak za pomoc myszy rysowa obszary na obrazie.\n" << std::endl;
}
int main( int argc, char** argv ) {
  help(argv);
  box = cv::Rect(-1,-1,0,0);
  cv::Mat image(200, 200, CV_8UC3), temp;
  image.copyTo(temp);
  box   = cv::Rect(-1,-1,0,0);
  image = cv::Scalar::all(0);
  cv::namedWindow( "Box Example" );
  // To jest kluczowe miejsce, w ktrym instalujemy funkcj zwrotn.
  // Zwr uwag na to, e argument params zosta ustawiony na obraz, z ktrym pracujemy,
  // dziki czemu funkcja zwrotna bdzie moga go edytowa.
  //
 cv::setMouseCallback(
   "Box Example",
   my_mouse_callback,
   (void*)&image
 );
 // Gwna ptla programu. W tym miejscu kopiujemy obraz roboczy do obrazu tymczasowego
 // i jeli uytkownik rysuje, wstawiamy aktualnie tworzony prostokt na ten obraz tymczasowy.
 // Wywietlamy obraz tymczasowy i czekamy 15 ms na nacinicie klawisza, a nastpnie powtarzamy czynno.
 //
 for(;;) {
    image.copyTo(temp);
    if( drawing_box ) draw_box( temp, box );
    cv::imshow( "Box Example", temp );
    if( cv::waitKey( 15 ) == 27 ) break;
  }
  return 0;
}

// To jest nasza funkcja zwrotna obsugi myszy. Jeeli uytkownik nacinie lewy przycisk, zaczynamy rysowanie prostokta.
// Gdy uytkownik puci przycisk myszy, dodajemy prostokt do biecego obrazu. 
// Kiedy uytkownik przecignie mysz (z nacinitym przyciskiem), zmieniamy rozmiar prostokta.
//
void my_mouse_callback(
int event, int x, int y, int flags, void* param) 
{
  cv::Mat& image = *(cv::Mat*) param;
  switch( event ) {
    case cv::EVENT_MOUSEMOVE: {
      if( drawing_box ) {
        box.width  = x-box.x;
        box.height = y-box.y;
      }
    }
    break;
 case cv::EVENT_LBUTTONDOWN: {
      drawing_box = true;
      box = cv::Rect( x, y, 0, 0 );
    }
    break;
    case cv::EVENT_LBUTTONUP: {
      drawing_box = false;
      if( box.width < 0  ) {

        box.x += box.width;
        box.width *= -1;
      }
      if( box.height < 0 ) {
        box.y += box.height;
        box.height *= -1;
      }
      draw_box( image, box );
    }
    break;
  }

}
