// Exercises_10_4.cpp ćwiczenia z końca rozdziału 10
//1
#include <opencv2/opencv.hpp>
#include <iostream>

using namespace cv;
using namespace std;


void help(const char **argv) {
	cout << "\n\n"
		<< "Ten program rozwiązuje ćwiczenia z rozdziału 8 \n"
		<< "Wywołanie:\n"
		<< argv[0] << " <path/video_name>\n\n"
		<< "Na przykład: ./" << argv[0] << " ../tree.avi\n"
		<< endl;
}

int main( int argc, const char** argv )
{
	help(argv);
	if(argc < 2) {
		cout << "\nBłąd: za mało parametrów.\n" << endl;
		return -1;
	}
	/************************************************************************/
	/* 4.	Napisz program, który (1) wczytuje klatki z filmu wideo, (2) zamienia wynik na skalę szarości i (3) wykonuje detekcję krawędzi algorytmem Canny’ego w obrazie. Wyświetl wszystkie trzy etapy przetwarzania w trzech osobnych oknach, z których każde ma nazwę zgodną z jego funkcją.
a.	Wyświetl wszystkie trzy etapy przetwarzania na jednym obrazie. (Podpowiedź: utwórz kolejny obraz o takiej samej wysokości i trzy razy większej szerokości niż wymiary klatki. Skopiuj obrazy do tego obrazu za pomocą wskaźników (sprytniej) lub tworząc trzy nowe nagłówki obrazu wskazujące na początek, do jednej trzeciej i do dwóch trzecich szerokości obrazu imageData. Następnie posłuż się funkcją Mat::copyTo()).
b.	Wpisz odpowiednie etykiety tekstowe opisujące sposób przetwarzania w każdym segmencie.
*/
	/************************************************************************/
	
	VideoCapture capture; 
	if(!capture.open(argv[1])){
		cout << "Nie udało się otworzyć pliku " << argv[1] << endl;
		return 1;
	}
	double rate=capture.get(CV_CAP_PROP_FPS);
	Mat MatFrame;
	Mat MatGray;
	Mat MatCanny;
	int delay=1000/rate;
	cout << "rate = " << rate << ", delay = " << delay << endl;
	cout << "\nEsc, aby zamknąć, dowolny klawisz zwalnia dane i zamyka program.\n" << endl; 
	int frame_count = 0;
	while(1)
	{
		capture >> MatFrame;
		if( !MatFrame.data ) {
			cout << "Koniec przechwytywania" << endl;
			break;
		}

		//(1)
		imshow("Surowe wideo",MatFrame);
		//(2)
		cvtColor(MatFrame,MatGray,COLOR_BGR2GRAY);
		imshow("Wideo w odcieniach szarości",MatGray);
		//(3)
		Canny(MatGray,MatCanny,100,255);
		imshow("Wideo Canny'ego",MatCanny);
		//pytanie a
		Mat MatAll(MatFrame.rows,3* MatFrame.cols  ,CV_8UC3,Scalar::all(0));
		cvtColor(MatGray,MatGray,COLOR_GRAY2BGR);
		cvtColor(MatCanny,MatCanny,COLOR_GRAY2BGR);
		Mat MatSub = MatAll.colRange(0, MatFrame.cols);
		MatFrame.copyTo(MatSub);
		MatSub = MatAll.colRange( MatFrame.cols,2*MatFrame.cols);
		MatGray.copyTo(MatSub);
		MatSub = MatAll.colRange(2*MatFrame.cols,3*MatFrame.cols);
		MatCanny.copyTo(MatSub);
		//question b
		Scalar color = CV_RGB(255,0,0);
		putText(MatAll,"surowe wideo",Point(50,30),CV_FONT_HERSHEY_DUPLEX,1.0f,color);
		putText(MatAll,"wideo w odcieniach szarości",Point(50+MatFrame.cols,30),CV_FONT_HERSHEY_DUPLEX,1.0f,color);
		putText(MatAll,"wideo canny'ego",Point(50+2*MatFrame.cols,30),CV_FONT_HERSHEY_DUPLEX,1.0f,color);
		imshow("wszystkie",MatAll);

		if ((cv::waitKey(delay) & 255) == 27)
			break;			
	}
	waitKey();
	capture.release();
	return 0;

}
