//Exercises_9_4.cpp ćwiczenia z końca rozdziału 9
#include <opencv2/opencv.hpp>
#include <iostream>

using namespace cv;
using namespace std;

 
void help(const char **argv) {
	cout << "\n\n"
		<< "Ten program rozwiązuje ćwiczenia 4 i 5 z końca rozdziału 9.\n"
		<< "Wywołanie:\n"
		<< argv[0] << " <path/image_name1>" << " <path/image_name2>\n\n"
		<< "Na przykład: ./" << argv[0] << " ../left.jpg "<< " ../left.jpg\n"
		<< endl;
}

int main( int argc, const char** argv )
{
	help(argv);
	if(argc < 3) {
		cout << "\nBłąd: za mało parametrów.\n" << endl;
		return -1;
	}
	Mat temp;

	/************************************************************************/
	/* 4.	Za pomocą aparatu fotograficznego wykonaj dwa zdjęcia tej samej sceny, jak najdelikatniej przesuwając aparat. Załaduj otrzymane zdjęcia do komputera jako src1 i src2.
a.	Oblicz wartość bezwzględną z różnicy src1 i src2 (odejmij jeden obraz od drugiego). Obraz wynikowy nazwij diff12 i go wyświetl. Jeśli zadanie zostało wykonanie perfekcyjnie, obraz ten powinien być czarny. Dlaczego nie jest?
b.	Utwórz obraz cleandiff, przepuszczając przez funkcję cv::erode(), a następnie cv::dilate() obraz diff12. Wyświetl wynik.
c.	Utwórz obraz dirtydiff, przepuszczając przez funkcję cv::dilate(), a następnie cv::erode() obraz diff12. Wyświetl wynik.
d.	Wyjaśnij różnicę między obrazami cleandiff i dirtydiff.
/************************************************************************/
	Mat src1 = imread(argv[1],IMREAD_GRAYSCALE);
	Mat src2 = imread(argv[2],IMREAD_GRAYSCALE);
	if (src1.empty() || src2.empty())
	{
		cout << "\nBłąd: parametr nie jest nazwą obrazu.\n" << endl;
		return -1;
	}
	//a
	Mat diff12 =  src1 - src2;
	imshow("diff12",diff12);
	//b
	Mat cleandiff;
	erode(diff12,cleandiff,Mat());
	dilate(cleandiff,cleandiff,Mat());
	imshow("cleandiff",cleandiff);
	//c
	Mat dirtydiff;
	dilate(diff12,dirtydiff,Mat());
	erode(dirtydiff,dirtydiff,Mat());
	imshow("dirtydiff",dirtydiff);
	//d
	absdiff(cleandiff,dirtydiff,temp) ;
	imshow("absdiff",temp);
	// różnica między cleandiff i dirtydiff to różnica między „otwary” i „zamknięty”
	waitKey();
	return 0;

}
