// Listing 2.10. Ten sam obiekt moe adowa filmy z kamery lub pliku
// 
#include <opencv2/opencv.hpp>
#include <iostream>

void help(char** argv ) {
	std::cout << "\n"
	<< "\nListing 2.10. Ten sam obiekt moe adowa filmy z kamery lub pliku"
    << "\nWywoanie:\n"  
	<< argv[0] <<" [path/image]\n"
	<< "\nlub z kamery:\n"
	<< argv[0]
	<< "\nNa przykad:\n"
	<< argv[0] << " ../tree.avi\n"
	<< std::endl;
}
	

int main( int argc, char** argv ) {
	
	help(argv);



  cv::namedWindow( "Listing 2.10", cv::WINDOW_AUTOSIZE );
  cv::VideoCapture cap;

  if (argc==1) {
    cap.open(0); // otwiera pierwsz kamer
  } else {
    cap.open(argv[1]);
  }

  if( !cap.isOpened() ) { // sprawdza czy si udao
    std::cerr << "Nie udao si." << std::endl;
    return -1;
  }

  cv::Mat frame;

  for(;;) {

    cap >> frame;

    if( frame.empty() ) break; // Ran out of film

    cv::imshow( "Listing 2.10", frame );

    if( (char) cv::waitKey(33) >= 0 ) break;

  }

  return 0;

}
