/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 17.2: Kod absolutnie minimalnego serwera
https://www.exploringarduino.com/content2/ch17

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

// Absolutnie minimalny serwer sieciowy Arduino
// Część kodu zaadaptowana z przykładowego kodu Arduino napisanego przez Toma Igoe

#include <SPI.h>
#include <WiFi101.h>

// Informacje o sieci Wi-Fi
const char WIFI_SSID[]     = "TUTAJ UMIEŚĆ NAZWĘ SIECI";      // SSID sieci Wi-Fi
const char WIFI_PASSWORD[] = "TUTAJ UMIEŚĆ HASŁO DO SIECI";  // Hasło do sieci Wi-Fi

// Informowanie o statusie połączenia za pomocą znajdującej się na płytce diody LED 
const int ONBOARD_LED = 13;

// Serwer będzie nasłuchiwał portu 80 (standardowy port HTTP)
WiFiServer server(80);

// Zmienna potrzebna do sprawdzania czy jesteśmy połączeni z punktem dostępu sieci Wi-Fi
int wifi_status = WL_IDLE_STATUS; 

void setup()
{
  // Ustawienie odpowiednich pinów czipa Wi-Fi
  WiFi.setPins(8,7,4,2);

  // Ustawienie pinów
  pinMode(ONBOARD_LED, OUTPUT);
  digitalWrite(ONBOARD_LED, LOW);

  // Uruchomienie interfejsu szeregowego
  Serial.begin(9600);

  // M0 ma sprzętowy interfejs USB, dlatego poniższa linijka nie powinna być oznaczona jako komentarz,
  // jeśli chcesz, aby program czekał, aż otworzysz monitor portu szeregowego. Oznacz ją jako komentarz,
  // jeśli chcesz, aby szkic działał bez otwierania konsoli szeregowej (lub gdy moduł jest zasilany baterią).

  while(!Serial);

  Serial.print("Łączenie z: ");
  Serial.println(WIFI_SSID);
  WiFi.setTimeout(5000);  // Poczekaj 5 s na połączenie
  while (wifi_status != WL_CONNECTED)
  {
    wifi_status = WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  }
  Serial.println("Połączono!\n");
  digitalWrite(ONBOARD_LED, HIGH);  // Po połączeniu zapal znajdującą się na płytce diodę LED 

  // Uruchomienie serwera
  server.begin();
  Serial.println("Serwer uruchomiony!");

  // Wyświetl przypisany przez DHCP adres IP
  IPAddress ip = WiFi.localIP();
  Serial.print("Steruj tym Arduino na: http://");
  Serial.println(ip);
  Serial.println("");
}

void loop()
{
  // Uruchom serwer nasłuchujący przychodzących połączeń z klientami
  WiFiClient client = server.available();

  // Czy klient (przeglądarka) się połączył?
  if(client)
  {
    // Gdy połączenie jest aktywne, sprawdzaj przychodzące linie.
    while (client.connected())
    {
      // Za jednym razem będziemy czytać jedną linijkę przychodzących danych.
      String incoming_line = "";
      // Użyj pętli do-while, abyśmy nie zaczęli sprawdzać formatowania linii,
      // dopóki łańcuch znaków nie zawiera swojego pierwszego znaku.
      do
      {
        while(!client.available());  // Czekaj na następny bajt
        char c = client.read();  // Po jego otrzymaniu, przeczytaj go
        incoming_line += c;  // i dołącz do bieżącej linii
      } while (!incoming_line.endsWith("\r\n"));
      
      Serial.print(incoming_line);  // Wyświetl właśnie otrzymaną linię
  
      // Jeżeli ostatnia linia była pusta (jedynie miała znak powrotu karetki i znak nowej linii),
      // to znaczy, że odebraliśmy już całe żądanie.

      if (incoming_line == "\r\n")
      {
        // Musimy potwierdzić otrzymanie żądania przez wysłanie odpowiedniego kodu.
        client.println("HTTP/1.1 200 OK");
        client.println("Content-type:text/html");
        client.println();
        
        // Możemy zakończyć połączenie.
        delay(50);
        client.stop();
      }
    }
  }
}
