/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 15.1: Test modułu radiowego
https://www.exploringarduino.com/content2/ch15

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Prosty test modułu radiowego

//Program zakłada, że używany jest typ chwilowy modułu odbiornika!
//Typ chwilowy M4 działa tak samo jak przełącznik chwilowy.
//Gdy przycisk jest wciśnięty, pin D2 ma stan wysoki.
//Gdy przycisk nie jest wciśnięty, pin D2 ma stan niski.

//Pin wejścia/wyjścia Arduino jest podłączony do pinu na module oznaczonego jako D2 
const int TRIGGER_PIN = A1;

//Zaświecimy wbudoewaną diodę LED, gdy przycisk będzie wciśnięty.
const int LED_PIN = 13;

//Deklaracja zmiennej przechowującej czas rozpoczęcia wciskania przycisku
unsigned long start_time;

//Deklaracja zmiennej przechowującej informację o nowym przyciśnięciu przycisku
boolean announced;

void setup()
{
  Serial.begin(9600);
  Serial.println("Test modułu radiowego");
  
  //Pin LED musi być ustawiony jako wyjście
  pinMode(LED_PIN, OUTPUT);
}

void loop()
{
  digitalWrite(LED_PIN, LOW); //Wyłączenie diody LED gdy przycisk jest zwolniony
  announced = false; //Przycisk zwolniony

  //Pętla, która wykonuje się wtedy, kiedy przycisk jest wciśnięty
  while (digitalRead(TRIGGER_PIN))
  {
    //Raz na wciśnięcie wykonują się poniższe operacje:
    if (!announced)
    {
      start_time = millis();
      Serial.print("WCIŚNIĘTY...");
      announced = true; // Wyświetla informację tylko raz
    }
    digitalWrite(LED_PIN, HIGH);
  }

  //Gdy przycisk zostanie zwolniony, zanotuj jak długo był wciśnięty
  if (announced)
  {
    Serial.print("ZWOLNIONY po ");
    unsigned long duration = millis() - start_time;
    Serial.print(round(duration/1000.0)); //Wyświetla informację w sekundach o tym, jak długo przycisk był wciśnięty.
    Serial.println(" sekundach."); 
  }
}
