/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 7.6: Kod Processing odczytujący dane i zmieniający kolor na ekranie
https://www.exploringarduino.com/content2/ch7

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Szkic Processing odczytujący dane i zmieniający kolor na ekranie

//Import i inicjalizacja biblioteki portu szeregowego
import processing.serial.*;
Serial port;

float brightness = 0; //Zmienna przechowująca wartość z potencjometru

void setup()
{
  size(500,500);                         //Rozmiar okna
  port = new Serial(this, "COM3", 9600); //Otwarcie terminala
  port.bufferUntil('\n');                //Ustawienie portu, aby czytał dane do momentu napotkania na znak nowej linii
}

void draw()
{
  background(0,0,brightness); //Aktualizacja wyglądu okna
}
 
void serialEvent (Serial port)
{
  brightness = float(port.readStringUntil('\n')); //Odebranie wartości z Arduino
}
