/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 5.3: Sterowanie silnikiem krokowym
https://www.exploringarduino.com/content2/ch5

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Proste sterowanie silnikiem krokowym za pomocą mostka H

#include <Stepper.h>

//Stałe silnika
//Większość silników NEMA-17 wykonuje 200 kroków
const int STEPS_PER_REV = 200; //200 kroków

//Piny mostku H
const int COIL1_MC1  = 2;  //Przełącznik 1 sterujący fazą 1
const int COIL1_MC2  = 3;  //Przełącznik 2 sterujący fazą 1
const int COIL2_MC1  = 4;  //Przełącznik 1 sterujący fazą 2
const int COIL2_MC2  = 5;  //Przełącznik 2 sterujący fazą 2

// Inicjalizacja biblioteki obsługującej silnik krokowy i jej przekazanie do pinów sterujących przełącznikami
Stepper myStepper(STEPS_PER_REV, COIL1_MC1, COIL1_MC2, COIL2_MC1, COIL2_MC2);

void setup()
{
  //Ustawienie prędkości silnika krokowego
  myStepper.setSpeed(60); //60 obrotów na minutę
}

void loop()
{
  //obrót o jeden krok w jednym kierunku:
  myStepper.step(STEPS_PER_REV);
  delay(500);

  //obrót o jeden krok w przeciwnym kierunku:
  myStepper.step(-STEPS_PER_REV);
  delay(500);
}
