/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 5.1: Serwomechanizm sterowany potencjometrem
https://www.exploringarduino.com/content2/ch5

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Serwomechanizm sterowany potencjometrem
#include <Servo.h>

const int SERVO = 9; //Serwomotor podłączony do pinu 9
const int POT   = 0; //Potencjometr podłączony do analogowego pinu 0

Servo myServo;
int val = 0; //Zmienna przechowująca odczyty z potencjometru

void setup()
{
  //Dołączenie obiektu Servo
  myServo.attach(SERVO);
}

void loop()
{
  val = analogRead(POT);           //Oczytaj wartość potencjometru
  val = map(val, 0, 1023, 0, 179); //Przeskaluj odczyt na pozycję serwomotoru
  myServo.write(val);              //Ustaw serwomotor 
  delay(15);                       //Czekaj na serwomotor
}
