/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 4.2: Sterowanie prędkością silnika za pomocą potencjometru i mosku H
https://www.exploringarduino.com/content2/ch4

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Sterowanie silnikiem za pomocą mostku H
const int EN=9;   //Pin 1 mostku H
const int MC1=3;  //Pin 1 sterujący silnikiem
const int MC2=2;  //Pin 2 sterujący silnikiem
const int POT=0;  //Potencjometr podłączony do analogowego pinu 0

int val = 0;      //zmienna przechowująca odczyty z potencjometru
int velocity = 0; //zmienna przechowująca żądaną pręskość (od 0 do 255)

void setup()
{
    pinMode(EN, OUTPUT);
    pinMode(MC1, OUTPUT);
    pinMode(MC2, OUTPUT);
    brake(); //Na początku programu silnik jest zatrzymany
}

void loop()
{
    val = analogRead(POT);
 
    //jedź do przodu
    if (val > 562)
    {
        velocity = map(val, 563, 1023, 0, 255);
        forward(velocity);
    }
 
    //jedź do tyłu
    else if (val < 462)
    {
        velocity = map(val, 461, 0, 0, 255);
        reverse(velocity);
    }
 
    //hamuj
    else
    {
        brake();
    }
}

//Silnik jedzie do przodu z zadaną prędkością (od 0 do 255)
void forward (int rate)
{
    digitalWrite(EN, LOW);
    digitalWrite(MC1, HIGH);
    digitalWrite(MC2, LOW);
    analogWrite(EN, rate);
}

//Silnik jedzie do tyłu z zadaną prędkością (od 0 do 255)
void reverse (int rate)
{
    digitalWrite(EN, LOW);
    digitalWrite(MC1, LOW);
    digitalWrite(MC2, HIGH);
    analogWrite(EN, rate);
}

//Silnik hamuje
void brake ()
{
    digitalWrite(EN, LOW);
    digitalWrite(MC1, LOW);
    digitalWrite(MC2, LOW);
    digitalWrite(EN, HIGH);
}
