/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 4.4: Pojazd sterowany światłem
https://www.exploringarduino.com/content2/ch4

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Pojazd samojezdny podążający za światłem!

//Piny mostku H
const int RIGHT_EN  =9;  //Pin włączający mostku H dla prawego silnika
const int RIGHT_MC1 =2;  //Przełącznik sterujący 1 prawej strony mostka H
const int RIGHT_MC2 =3;  //Przełącznik sterujący 2 prawej strony mostka H
const int LEFT_EN   =10; //Pin włączający mostku H dla lewego silnika
const int LEFT_MC1  =4;  //Przełącznik sterujący 1 lewej strony mostka H
const int LEFT_MC2  =5;  //Przełącznik sterujący 2 lewej strony mostka H

//Piny czujników światła
const int LEFT_LIGHT_SENSOR  =0; //Fotorezystor podłączony do analogowego pinu 0
const int RIGHT_LIGHT_SENSOR =1; //Fotorezystor podłączony do analogowego pinu 1

//Movement Thresholds and Speeds
const int LIGHT_THRESHOLD_MIN = 810;  //Minimalny odczyt poziomu oświetlenia do wywołania ruchu
const int LIGHT_THRESHOLD_MAX = 1100; //Minimalny odczyt poziomu oświetlenia do wywołania ruchu
const int SPEED_MIN = 150;            //Minimalna prędkość silnika
const int SPEED_MAX = 255;            //Maksymalna prędkość silnika

void setup()
{
    //Piny wejścia i wyjścia mostku H
    pinMode(RIGHT_EN, OUTPUT);
    pinMode(RIGHT_MC1, OUTPUT);
    pinMode(RIGHT_MC2, OUTPUT);
    pinMode(LEFT_EN, OUTPUT);
    pinMode(LEFT_MC1, OUTPUT);
    pinMode(LEFT_MC2, OUTPUT);

    //Na pocżątku programu zatrzymaj oba silniki.
    brake("left");
    brake("right");

    //Uruchom monitor portu szeregowego w celu określenia prawidłowych poziomów światła.
    Serial.begin(9600);
}

void loop()
{
    //Oczytaj informacje z czujników światła.
    int left_light  = analogRead(LEFT_LIGHT_SENSOR);
    int right_light = analogRead(RIGHT_LIGHT_SENSOR);

    //Poczekaj 50 ms, aby odczyty w monitorze portu szeregowego były czytelne.
    delay(50);    

    //Dla każdego z czujników światła, ustaw proporcjonalną prędkość przeciwstawnego silnika.
    //Poniżej minimalnej wartości progowej, nie obracaj przeciwstawnym silnikiem.
    //Zauważ, że lewy czujnik steruje prawym silnikiem, i na odwrót.
    //Aby skręcić w lewo, prędkość prawego silnika musi być zwiększona.
    Serial.print("Prawo: ");
    Serial.print(right_light);
    Serial.print(" ");
    if (right_light >= LIGHT_THRESHOLD_MIN)
    {
      //Dopasuj poziom światła do prędkości i ogranicz wartość.
      int left_speed = map(right_light,
                           LIGHT_THRESHOLD_MIN, LIGHT_THRESHOLD_MAX,
                           SPEED_MIN, SPEED_MAX);
      left_speed = constrain(left_speed, SPEED_MIN, SPEED_MAX);
      Serial.print(left_speed);    //Wydrukuj prędkość silnika.
      forward("left", left_speed); //Obracaj przeciwległym silnikiem z obliczoną prędkością.
    }
    else
    {
      Serial.print("0");
      brake("left"); //Zatrzymaj przeciwległy silnik, gdy wartość światła jest poniżej minimum.
    }

    Serial.print("\tLewo: ");
    Serial.print(left_light);
    Serial.print(" ");
    if (left_light >= LIGHT_THRESHOLD_MIN)
    {
      //Dopasuj poziom światła do prędkości i ogranicz wartość.
      int right_speed = map(left_light,
                            LIGHT_THRESHOLD_MIN, LIGHT_THRESHOLD_MAX,
                            SPEED_MIN, SPEED_MAX);
      right_speed = constrain(right_speed, SPEED_MIN, SPEED_MAX);
      Serial.println(right_speed);   //Wydrukuj prędkość silnika.
      forward("right", right_speed); //Obracaj przeciwległym silnikiem z obliczoną prędkością.
    }
    else
    {
      Serial.println("0");
      brake("right"); //Zatrzymaj przeciwległy silnik, gdy wartość światła jest poniżej minimum.
    }
}

//Silnik obraca się do przodu z zadaną wartością (od 0 do 255).
//Funkcja może obracać lewym ("left") lub prawym ("right") silnikiem.
void forward (String motor, int rate)
{
    if(motor == "left")
    {
      digitalWrite(LEFT_EN, LOW);
      digitalWrite(LEFT_MC1, HIGH);
      digitalWrite(LEFT_MC2, LOW);
      analogWrite(LEFT_EN, rate);
    }
    else if(motor == "right")
    {  
      digitalWrite(RIGHT_EN, LOW);
      digitalWrite(RIGHT_MC1, HIGH);
      digitalWrite(RIGHT_MC2, LOW);
      analogWrite(RIGHT_EN, rate);
    }
}

//Zatrzymanie silników
//Funkcja może zatrzymać lewy ("left") lub prawy ("right") silnik.
void brake (String motor)
{
    if(motor == "left")
    {
      digitalWrite(LEFT_EN, LOW);
      digitalWrite(LEFT_MC1, LOW);
      digitalWrite(LEFT_MC2, LOW);
      digitalWrite(LEFT_EN, HIGH);
    }
    else if(motor == "right")
    {
      digitalWrite(RIGHT_EN, LOW);
      digitalWrite(RIGHT_MC1, LOW);
      digitalWrite(RIGHT_MC2, LOW);
      digitalWrite(RIGHT_EN, HIGH);
    }
}
