/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 14.3: Zapis i odczyt karty SD z wykorzystaniem zegara czasu rzeczywistego
https://www.exploringarduino.com/content2/ch14

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Zapis i odczyt karty SD z wykorzystaniem zegara czasu rzeczywistego

//Usuń znaczniki komentarza sprzed poniższej linii jeśli Twoja nakładka korzysta z DS1307, zamiast PCF8523
//#define RTC_CHIP_IS_DS1307

//Usuń znaczniki komentarza sprzed poniższej linii jeżeli chcesz ustawić czas zegara
//Ta linijka powinna zawsze być oznaczona jako komentarz, gdy program będzie już rzeczywiście rejestrował dane
//#define FORCE_UPDATE

#include <SD.h>     // Dołączenie biblioteki obsługującej karty SD
#include <Wire.h>   // Dołączenie biblioteki I2C dla zegara RTC
#include "RTClib.h" // Dołączenie biblioteki RTC


// Karta SD jest podłączona do standardowych pinów SPI
// Zegar RTC jest podłączony do standardowych pinów I2C

//Zawsze musimy ustawić pin CS dla karty SD
const int CS_PIN  = 10;

//Domyślna prędkość równa 5 s może być zamieniona na wartość z pliku speed.txt
int refresh_rate = 5000;

// Użycie flag kompilatora w celu ustawienia właściwego typu czipa
#ifdef RTC_CHIP_IS_DS1307
  RTC_DS1307 RTC;
  String chip = "DS1307";
#else
  RTC_PCF8523 RTC;
  String chip = "PCF8532";
#endif

// Użycie flag kompilatora w celu podjęcia decyzji, czy wykonać aktualizację zegara
#ifdef FORCE_UPDATE
  bool update_clock = true;
#else
  bool update_clock = false;
#endif

//Deklaracja zmiennych znakowych przechowujących godzinę i datę
String time, date;

void updateDateTime()
{
  //Pobranie aktualnej informacji o dacie oraz godzinie i zapisanie ich w zmiennych
  DateTime datetime = RTC.now();
  String year  = String(datetime.year(),  DEC);
  String month = String(datetime.month(), DEC);
  String day  = String(datetime.day(),  DEC);
  String hour  = String(datetime.hour(),  DEC);
  String minute = String(datetime.minute(), DEC);
  String second = String(datetime.second(), DEC);
 
  //Połączenie zmiennych składających się na godzinę i datę
  date = year + "/" + month + "/" + day;
  time = hour + ":" + minute + ":" + second;
}

void setup()
{
  Serial.begin(9600);
 
  //Pin CS musi być ustawiony jako wyjście
  pinMode(CS_PIN, OUTPUT);
 
  //Inicjalizacja biblioteki RTC
  RTC.begin();
 
  //Zawsze zaktualizuj czas jeśli RTC nie jest uruchomiony
  #ifdef RTC_CHIP_IS_DS1307
    if (!RTC.isrunning()) update_clock = true;
  #else
    if (!RTC.initialized()) update_clock = true;
  #endif

// Jeżeli zegar RTC nie działa lub zostało wymuszone jego zatrzymanie, ustaw czas przez pobranie daty i godziny z komputera
  if (update_clock)
  {
    Serial.print(F("Konfiguracja "));
    Serial.print(chip);
    Serial.print(F(" ustawienie czasu..."));
    RTC.adjust(DateTime(F(__DATE__), F(__TIME__)));
    Serial.println(F("Gotowe!"));
  }
  else
  {
    Serial.print(chip);
    Serial.println(F(" - czas został ustawiony!"));
  }

  //Wyświetlanie daty i godziny
  updateDateTime();
  Serial.print(F("Data RTC: "));
  Serial.println(date);
  Serial.print(F("Godzina RTC: "));
  Serial.println(time);
 
  //Inicjalizacja karty SD
  Serial.print(F("Inicjalizacja karty SD..."));
  if (!SD.begin(CS_PIN))
  {
    Serial.println(F("Nieudane połączenie z kartą SD!"));
    while(1);
  }
  Serial.println(F("Karta SD gotowa od użycia!"));
 
//Odczyt informacji konfiguracyjnych (speed.txt)
  File commandFile = SD.open("speed.txt");
  if (commandFile)
  {
     Serial.print(F("Odczyt pliku konfiguracyjnego..."));
  
     while(commandFile.available())
     {
       refresh_rate = commandFile.parseInt();
     }
     Serial.print(F("Prędkość odświeżania = "));
     Serial.print(refresh_rate);
     Serial.println(F("ms"));
     commandFile.close(); //Po zakończeniu pracy zamknij plik
  }  
  else
  {
    Serial.println(F("Nieudany odczyt pliku konfiguracyjnego."));
    Serial.print(F("Zostanie zastosowana domyślna prędkość odświeżania: "));
    Serial.print(refresh_rate);
    Serial.println(F("ms!"));
  } 
 
  //Zapis nagłówków kolumn
  File dataFile = SD.open("log.csv", FILE_WRITE);
  if (dataFile)
  {
    dataFile.println(F("\nPoczątek nowego rejestru!"));
    dataFile.println(F("Data,Godzina,Zdanie"));
    dataFile.close(); //Dane nie zostaną zapisane, dopóki nie wywołamy polecenia close()!
  
    //Wyświetlanie zapisanych danych w monitorze portu szeregowego na potrzeby debugowania
    Serial.println(F("\nPoczątek nowego rejestru!"));
    Serial.println(F("Data,Godzina,Zdanie"));
  }
  else
  {
    Serial.println(F("Błąd podczas próby otwarcia pliku rejestru!"));
    while(1);
  }
 
}

void loop()
{ 
  updateDateTime(); //Pobranie bieżącej daty i godziny
  String dataString = "Witaj!";
 
  //Otwarcie pliku i zapisanie w nim danych 
  File dataFile = SD.open("log.csv", FILE_WRITE);
  if (dataFile)
  {
    
    dataFile.print(date);
    dataFile.print(F(","));
    dataFile.print(time);
    dataFile.print(F(","));
    dataFile.println(dataString);
    dataFile.close(); //Dane nie zostaną zapisane, dopóki  nie wywołamy polecenia close()!
  
    //Wyświetlanie zapisanych danych w monitorze portu szeregowego na potrzeby debugowania
    Serial.print(date);
    Serial.print(F(","));
    Serial.print(time);
    Serial.print(F(","));
    Serial.println(dataString);
  }
  else
  {
    Serial.println(F("Błąd podczas próby otwarcia pliku rejestru!"));
  }
  delay(refresh_rate);
}
