/*
Odkrywanie świata Arduino, Wydanie drugie
Listing 6.1: Odtwarzanie muzyki na Arduino
https://www.exploringarduino.com/content2/ch6

Wszelkie prawa zastrzeżone 2019 Jeremy Blum ( https://www.jeremyblum.com )
Licencja MIT ( https://github.com/sciguy14/Exploring-Arduino-2nd-Edition/blob/master/LICENSE.md )
*/

//Odtwarzanie melodii za pomocą głośnika

#include "pitches.h" //Plik nagłówkowy z definicją dźwięków

const int SPEAKER=9;  //Pin, do którego podłączony jest głośnik

//Tablica z nutami
int notes[] = {
 NOTE_A4, NOTE_E3, NOTE_A4, 0, 
 NOTE_A4, NOTE_E3, NOTE_A4, 0,
 NOTE_E4, NOTE_D4, NOTE_C4, NOTE_B4, NOTE_A4, NOTE_B4, NOTE_C4, NOTE_D4,
 NOTE_E4, NOTE_E3, NOTE_A4, 0
};

//Czas trwania każdej nuty (w ms)
int times[] = {
 250, 250, 250, 250, 
 250, 250, 250, 250,
 125, 125, 125, 125, 125, 125, 125, 125,
 250, 250, 250, 250 
};


void setup()
{
 //Zagraj każdą nutę odpowiednio długo
 for (int i = 0; i < 20; i++)
 {
  tone(SPEAKER, notes[i], times[i]);
  delay(times[i]);
 }
}

void loop()
{
 //Naciśnij przycisk reset, aby ponownie odtworzyć melodię. 
}
