#import <Foundation/Foundation.h>

static NSMutableSet *unique_strings;

NSString *uniqueString(const char *str)
{
	NSString *new = [[NSString alloc] 
		initWithUTF8String: str];

	NSString *old = 
		[unique_strings member: new];

	if (nil != old)
	{
		[new release];
		return old;
	}
	[unique_strings addObject: new];
	return new;
}

int main(void)
{
	NSAutoreleasePool *pool = [NSAutoreleasePool new];
	unique_strings = [NSMutableSet new];
	NSString *str1 = uniqueString("str1");
	NSString *str2 = uniqueString("str1");
	NSString *str3 = uniqueString("str2");
	NSString *str4 = uniqueString("str2");
	NSLog(@"%x, %x, %x, %x", str1, str2, str3, str4);
	return 0;
}
