#import <Foundation/Foundation.h>
#include <objc/runtime.h>

id fakeDealloc(id self, SEL _cmd, ...)
{
	NSLog(@"%@ wyslano wiadomosc -dealloc", self);
}

void makeIndestructible(id obj)
{
	Class new = 
		objc_allocateClassPair(obj->isa, "Fake", 0);
	class_addMethod(new, @selector(dealloc), 
			fakeDealloc, "v@:");
	objc_registerClassPair(new);
	obj->isa = new;
}

int main(void)
{
	[NSAutoreleasePool new];
	id obj = [NSObject new];
	// Uwaga: Drugie wywolanie tej funkcji nie uda sie, 
	// bo klasa Fake bedzie juz istniala.
	makeIndestructible(obj);
	[obj release];
	return 0;
}
