#import <Foundation/Foundation.h>

@interface KeyPublic : NSObject @end
@implementation KeyPublic @end

@interface KeyIVar : KeyPublic 
{
	int integer;
}
@end
@implementation KeyIVar @end

@interface KeyAccessor : KeyIVar @end
@implementation KeyAccessor
- (int)integer
{
	return integer;
}
- (void)setInteger: (int)aValue
{
	integer = aValue;
}
@end
@interface KeyProperty : KeyPublic
@property int integer;
@end
@implementation KeyProperty
@synthesize integer;
@end

@interface KeyFallback : KeyPublic
{
	NSMutableDictionary *dict;
}
@end
@implementation KeyFallback
- (id)valueForUndefinedKey: (NSString*)aKey
{
	return [dict valueForKey: aKey];
}
- (void)setValue: (id)aValue
 forUndefinedKey: (NSString*)aKey
{
	[dict setValue: aValue
	        forKey: aKey];
}
@end

@implementation KeyFallback (NotRelevantToExample)
- (id)init
{
	if (nil == (self = [super init]))
	{
		return nil;
	}
	dict = [NSMutableDictionary new];
	return self;
}
- (void)dealloc
{
	[dict release];
	[super dealloc];
}
@end

void testKey(KeyPublic *object)
{
	[object setValue: @"42"
	          forKey: @"integer"];
	int value = 
		[[object valueForKey: @"integer"] 
				intValue];
	NSCAssert(value == 42, 
			@"Wartosc ustawiona i pobrana");
}

int main(void)
{
	[NSAutoreleasePool new];
	testKey([KeyIVar new]);
	testKey([KeyAccessor new]);
	testKey([KeyProperty new]);
	testKey([KeyFallback new]);
	return 0;
}
