#import <Foundation/Foundation.h>

@interface StringHolder : NSObject
{
	NSString *string;
	id delegate;
}
- (void)setStringValue: (NSString*)aString;
- (void)setDelegate: (id)aDelegate;
@end

@implementation StringHolder
// Nie rob tego!
- (void)setStringValue: (NSString*)aString
{
	[string release];
	string = [aString retain];
}
- (void)setDelegate: (id)aDelegate
{
	delegate = aDelegate;
}
@end
@implementation StringHolder (Correct)
// Zamiast tego zrob to:
- (void)setStringValue: (NSString*)aString
{
	id tmp = [aString retain];
	[string release];
	string = tmp;
}
@end
@implementation StringHolder (accessor)
- (NSString*)stringValue
{
	return [[string retain] autorelease];
}
@end
